/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.hive;

import com.alien.common.gameplay.hive.Hive;
import com.avp.AVP;
import com.lib.common.gameplay.util.spatial.Vec3Like;
import com.lib.common.gameplay.util.spatial.block.BlockPosVec3;
import com.lib.common.gameplay.util.spatial.sphere.layer.LayeredSphere;
import com.lib.common.gameplay.util.spatial.sphere.layer.SphereLayer;
import com.lib.common.gameplay.util.spatial.sphere.layer.SphereLayerDistanceTarget;
import com.lib.common.gameplay.util.spatial.sphere.layer.impl.PercentileSphereLayer;
import com.lib.common.gameplay.util.spatial.sphere.layer.impl.SupplyingPercentileSphereLayer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class HiveSpaceManager
implements LayeredSphere {
    private static final SphereLayer CENTER_LAYER = new PercentileSphereLayer(0.0f, 0.15f);
    private static final SphereLayer PRAETORIAN_LAYER = new PercentileSphereLayer(0.15f, 0.4f);
    private static final SphereLayer DRONE_LAYER = new PercentileSphereLayer(0.4f, 0.7f);
    private static final SphereLayer WARRIOR_LAYER = new PercentileSphereLayer(0.7f, 0.95f);
    private static final SphereLayer EDGE_LAYER = new PercentileSphereLayer(0.95f, 1.0f);
    private static final Supplier<Float> MAX_NORMALIZED_LEASH_RANGE_SUPPLIER = () -> {
        int hiveRadiusBlocks = AVP.config.hiveConfigs.HIVE_RADIUS_IN_BLOCKS;
        int hiveLeashRadiusInBlocks = AVP.config.hiveConfigs.HIVE_LEASH_RADIUS_IN_BLOCKS;
        return Float.valueOf(1.0f + (float)(hiveLeashRadiusInBlocks / hiveRadiusBlocks));
    };
    private static final Supplier<Float> MAX_NORMALIZED_BUFFER_SUPPLIER = () -> Float.valueOf(MAX_NORMALIZED_LEASH_RANGE_SUPPLIER.get().floatValue() * 2.0f);
    private static final SphereLayer LEASH_LAYER = new SupplyingPercentileSphereLayer(() -> Float.valueOf(1.0f), MAX_NORMALIZED_LEASH_RANGE_SUPPLIER);
    private static final SphereLayer BUFFER_LAYER = new SupplyingPercentileSphereLayer(MAX_NORMALIZED_LEASH_RANGE_SUPPLIER, MAX_NORMALIZED_BUFFER_SUPPLIER);
    public static final List<SphereLayer> HIVE_LAYERS = List.of(CENTER_LAYER, PRAETORIAN_LAYER, DRONE_LAYER, WARRIOR_LAYER, EDGE_LAYER, LEASH_LAYER, BUFFER_LAYER);
    private final Hive hive;

    public HiveSpaceManager(Hive hive) {
        this.hive = hive;
    }

    public boolean isEntityWithinHive(Entity entity) {
        return this.isBlockPosWithinHive(entity.blockPosition());
    }

    public boolean isBlockPosWithinHive(BlockPos blockPos) {
        return this.isWithinLayerOrBelow(EDGE_LAYER, new BlockPosVec3(blockPos));
    }

    public boolean isEntityLeashedToHive(Entity entity) {
        return this.isBlockPosLeashedToHive(entity.blockPosition());
    }

    public boolean isBlockPosLeashedToHive(BlockPos blockPos) {
        return this.isWithinLayerOrBelow(LEASH_LAYER, new BlockPosVec3(blockPos));
    }

    public boolean isEntityWithinHiveBuffer(Entity entity) {
        return this.isBlockPosWithinHiveBuffer(entity.blockPosition());
    }

    public boolean isBlockPosWithinHiveBuffer(BlockPos blockPos) {
        return this.isWithinLayerOrBelow(BUFFER_LAYER, new BlockPosVec3(blockPos));
    }

    public double distanceToCenterSqr(Entity entity) {
        return this.distanceToCenterSqr(entity.blockPosition());
    }

    public double distanceToCenterSqr(BlockPos blockPos) {
        return this.distanceToSqr(HiveLayer.CENTER, blockPos, SphereLayerDistanceTarget.INNER_BOUNDARY);
    }

    public double distanceToOuterBoundarySqr(HiveLayer hiveLayer, Entity entity) {
        return this.distanceToOuterBoundarySqr(hiveLayer, entity.blockPosition());
    }

    public double distanceToOuterBoundarySqr(HiveLayer hiveLayer, BlockPos blockPos) {
        return this.distanceToSqr(hiveLayer, blockPos, SphereLayerDistanceTarget.OUTER_BOUNDARY);
    }

    public double distanceToSqr(HiveLayer hiveLayer, Entity entity, SphereLayerDistanceTarget sphereLayerDistanceTarget) {
        return this.distanceToSqr(hiveLayer, entity.blockPosition(), sphereLayerDistanceTarget);
    }

    public double distanceToSqr(HiveLayer hiveLayer, BlockPos blockPos, SphereLayerDistanceTarget sphereLayerDistanceTarget) {
        return hiveLayer.sphereLayer.distanceSquaredTo(this, new BlockPosVec3(blockPos), sphereLayerDistanceTarget);
    }

    @Nullable
    public SphereLayer getLayerOrNull(BlockPos blockPos) {
        return LayeredSphere.super.getLayerOrNull(new BlockPosVec3(blockPos));
    }

    @Nullable
    public HiveLayer getHiveLayerOrNull(BlockPos blockPos) {
        SphereLayer sphereLayer = this.getLayerOrNull(blockPos);
        return sphereLayer == null ? null : HiveLayer.HIVE_LAYER_BY_SPHERE_LAYER_MAP.get(sphereLayer);
    }

    @Override
    public Vec3Like getCenter() {
        return new BlockPosVec3(this.hive.centerPosition());
    }

    @Override
    public float getRadius() {
        return AVP.config.hiveConfigs.HIVE_RADIUS_IN_BLOCKS;
    }

    @Override
    public List<SphereLayer> getAllLayers() {
        return HIVE_LAYERS;
    }

    public static enum HiveLayer {
        CENTER(CENTER_LAYER),
        PRAETORIAN(PRAETORIAN_LAYER),
        DRONE(DRONE_LAYER),
        WARRIOR(WARRIOR_LAYER),
        EDGE(EDGE_LAYER),
        LEASH(LEASH_LAYER),
        BUFFER(BUFFER_LAYER);

        private static final Map<SphereLayer, HiveLayer> HIVE_LAYER_BY_SPHERE_LAYER_MAP;
        private final SphereLayer sphereLayer;

        private HiveLayer(SphereLayer sphereLayer) {
            this.sphereLayer = sphereLayer;
        }

        public SphereLayer getSphereLayer() {
            return this.sphereLayer;
        }

        static {
            HIVE_LAYER_BY_SPHERE_LAYER_MAP = Arrays.stream(HiveLayer.values()).collect(Collectors.toMap(hiveLayer -> hiveLayer.sphereLayer, Function.identity()));
        }
    }
}

