/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.hive.membership;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.hive.Hive;
import com.just.core.functional.option.Option;
import com.lib.common.gameplay.NBTSerializable;
import com.lib.common.gameplay.util.CompoundTagUtil;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HiveLeadershipManager
implements NBTSerializable {
    private static final String LEADER_ID_KEY = "HiveLeaderId";
    private final Hive hive;
    private Option<UUID> leaderIdOption;

    public HiveLeadershipManager(Hive hive) {
        this.hive = hive;
        this.leaderIdOption = Option.none();
    }

    public void tick() {
        if (!this.hive.getMembershipManager().isMember(this.getLeaderIdOrNull())) {
            this.setLeaderId(null);
        }
    }

    public void removeLeadership(@NotNull Entity entity) {
        this.removeLeadership(entity.getUUID());
    }

    public void removeLeadership(@NotNull UUID uuid) {
        if (this.leaderIdOption.contains((Object)uuid)) {
            this.leaderIdOption = Option.none();
        }
    }

    public boolean isLeader(Entity entity) {
        return this.leaderIdOption.contains((Object)entity.getUUID());
    }

    @Nullable
    public UUID getLeaderIdOrNull() {
        return (UUID)this.leaderIdOption.unwrapOr(null);
    }

    public Option<Alien> getLeader() {
        return Option.ofNullable((Object)this.getLeaderOrNull());
    }

    @Nullable
    public Alien getLeaderOrNull() {
        Level level = this.hive.level();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return (Alien)this.leaderIdOption.map(arg_0 -> ((ServerLevel)serverLevel).getEntity(arg_0)).filter(entity -> entity instanceof Alien).map(entity -> (Alien)entity).unwrapOr(null);
    }

    public void setLeaderId(@Nullable UUID id) {
        this.leaderIdOption = Option.ofNullable((Object)id);
    }

    @Override
    public void load(CompoundTag compoundTag) {
        this.leaderIdOption = Option.ofNullable((Object)CompoundTagUtil.getUUIDOrNull(compoundTag, LEADER_ID_KEY));
    }

    @Override
    public void save(CompoundTag compoundTag) {
        this.leaderIdOption.ifSome(leaderId -> compoundTag.putUUID(LEADER_ID_KEY, leaderId));
    }
}

