/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.hive.membership;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.xenomorph.drone.Drone;
import com.alien.common.gameplay.entity.living.alien.xenomorph.runner.Runner;
import com.alien.common.gameplay.hive.Hive;
import com.alien.common.gameplay.hive.HiveSpaceManager;
import com.avp.AVP;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.lib.common.gameplay.NBTSerializable;
import com.lib.common.gameplay.entity.EntityReserves;
import com.lib.common.gameplay.util.spatial.block.BlockPosVec3;
import com.lib.common.gameplay.util.spatial.sphere.layer.SphereLayer;
import com.lib.common.util.codec.schema.CodecSchemas;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;

public class HiveReserveManager
implements NBTSerializable {
    private static final String NBT_HIVE_MEMBER_RESERVES = "hiveMemberReserves";
    private static final int FIVE_MINUTES_IN_TICKS = 6000;
    private final EntityReserves hiveMemberReserves = new EntityReserves();
    private final Hive hive;

    public HiveReserveManager(Hive hive) {
        this.hive = hive;
    }

    public void tick() {
        if (this.hive.ageInTicks() % 6000 == 0) {
            SphereLayer warriorLayer = HiveSpaceManager.HiveLayer.WARRIOR.getSphereLayer();
            int numberOfXenomorphsInOuterEdges = (int)this.hive.getMembershipManager().getLoadedMembers().stream().filter(entity -> entity.getType().is(AVPEntityTypeTags.XENOMORPHS) && !this.hive.getSpaceManager().isWithinLayerOrBelow(warriorLayer, new BlockPosVec3(entity.blockPosition()))).count();
            if (numberOfXenomorphsInOuterEdges > 0) {
                int half = numberOfXenomorphsInOuterEdges / 2;
                int remainder = numberOfXenomorphsInOuterEdges % 2;
                boolean isDroneFirst = this.hive.getRandom().nextBoolean();
                EntityType<? extends Alien> droneType = Drone.getType(this.hive.getVariant());
                EntityType<? extends Alien> runnerType = Runner.getType(this.hive.getVariant());
                this.hiveMemberReserves.add(droneType, half);
                this.hiveMemberReserves.add(runnerType, half);
                if (remainder > 0) {
                    EntityType<? extends Alien> extraType = isDroneFirst ? droneType : runnerType;
                    this.hiveMemberReserves.add(extraType, 1);
                }
            }
        }
    }

    public boolean canSpawn(EntityType<?> entityType) {
        return this.hiveMemberReserves.getCount(entityType) > 0;
    }

    public void add(EntityType<?> entityType, int count) {
        this.hiveMemberReserves.add(entityType, count);
    }

    public int getCount(EntityType<?> entityType) {
        return this.hiveMemberReserves.getCount(entityType);
    }

    public int getCountMatching(Predicate<EntityType<?>> predicate) {
        return this.hiveMemberReserves.getCountMatching(predicate);
    }

    public List<EntityType<?>> getAvailableEntityTypes() {
        return this.hiveMemberReserves.getAvailableEntityTypes();
    }

    @Override
    public void load(CompoundTag compoundTag) {
        EntityReserves.CODEC.decode(CodecSchemas.NBT, (Object)compoundTag.getCompound(NBT_HIVE_MEMBER_RESERVES)).inspectErr(tag -> AVP.LOGGER.error("Failed to load tag '{}'. Tag: {}", (Object)NBT_HIVE_MEMBER_RESERVES, tag)).ifOk(loadedEntityReserves -> this.hiveMemberReserves.putAll(loadedEntityReserves.getBackingMap()));
    }

    @Override
    public void save(CompoundTag compoundTag) {
        compoundTag.put(NBT_HIVE_MEMBER_RESERVES, (Tag)EntityReserves.CODEC.encode(CodecSchemas.NBT, (Object)this.hiveMemberReserves));
    }
}

