/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.util;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.model.alien.variant.AlienVariant;
import com.avp.common.util.AVPEntityTransitionUtil;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class AlienTransitionUtil {
    public static <T extends Alien> AlienTransitionResult transitionIntoVariant(T alien, AlienVariant alienVariant) {
        Level level = alien.level();
        if (level.isClientSide) {
            return AlienTransitionResult.ClientSide.INSTANCE;
        }
        if (alien.getVariant() == alienVariant) {
            return AlienTransitionResult.AlreadyDesiredVariant.INSTANCE;
        }
        EntityType<? extends Alien> variantType = alien.getTypeForVariant(alienVariant);
        if (variantType == null) {
            return AlienTransitionResult.NoTypeForVariant.INSTANCE;
        }
        return new AlienTransitionResult.Result(AVPEntityTransitionUtil.transitionInto(alien, variantType));
    }

    public static sealed interface AlienTransitionResult {

        public record Result(AVPEntityTransitionUtil.EntityTransitionResult result) implements AlienTransitionResult
        {
        }

        public static enum NoTypeForVariant implements AlienTransitionResult
        {
            INSTANCE;

        }

        public static enum AlreadyDesiredVariant implements AlienTransitionResult
        {
            INSTANCE;

        }

        public static enum ClientSide implements AlienTransitionResult
        {
            INSTANCE;

        }
    }
}

