/*
 * Decompiled with CFR 0.152.
 */
package com.avp.client.animation;

import mod.azure.azurelib.rewrite.animation.AzAnimationContext;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.model.AzBone;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.WalkAnimationState;

public class BasicAnimationUtils {
    public static void applyHeadRotations(LivingEntity entity, AzAnimationContext<?> context, float partialTick, String headName, float pitchOffset) {
        AzBakedModel bakedModel = context.boneCache().getBakedModel();
        AzBone head = bakedModel.getBoneOrNull(headName);
        if (head != null) {
            float headPitch = BasicAnimationUtils.computeHeadPitch(entity, partialTick);
            head.setRotX(headPitch * ((float)Math.PI / 180) + pitchOffset);
            head.setRotY(BasicAnimationUtils.computeNetHeadYaw(entity, partialTick) * ((float)Math.PI / 180));
        }
    }

    public static void applyLimbRotations(LivingEntity entity, AzAnimationContext<?> context, float partialTick, String leftArmName, String rightArmName, String leftLegName, String rightLegName, float armOffset, float legOffset) {
        AzBakedModel bakedModel = context.boneCache().getBakedModel();
        float constant = 0.6662f;
        WalkAnimationState walkAnimation = entity.walkAnimation;
        float walkPosition = walkAnimation.position(partialTick);
        float walkSpeed = walkAnimation.speed();
        AzBone leftArm = bakedModel.getBoneOrNull(leftArmName);
        AzBone rightArm = bakedModel.getBoneOrNull(rightArmName);
        AzBone leftLeg = bakedModel.getBoneOrNull(leftLegName);
        AzBone rightLeg = bakedModel.getBoneOrNull(rightLegName);
        if (leftArm != null) {
            leftArm.setRotX(Mth.cos((float)(walkPosition * constant)) * 2.0f * walkSpeed * 0.5f + armOffset);
        }
        if (rightArm != null) {
            rightArm.setRotX(Mth.cos((float)(walkPosition * constant + (float)Math.PI)) * 2.0f * walkSpeed * 0.5f + armOffset);
        }
        if (leftLeg != null) {
            leftLeg.setRotX(Mth.cos((float)(walkPosition * constant + (float)Math.PI)) * 1.4f * walkSpeed * 0.5f + legOffset);
        }
        if (rightLeg != null) {
            rightLeg.setRotX(Mth.cos((float)(walkPosition * constant)) * 1.4f * walkSpeed * 0.5f + legOffset);
        }
    }

    private static float computeNetHeadYaw(LivingEntity entity, float partialTick) {
        Entity entity2;
        boolean shouldSit = entity.isPassenger() && entity.getVehicle() != null;
        float lerpBodyRot = Mth.rotLerp((float)partialTick, (float)entity.yBodyRotO, (float)entity.yBodyRot);
        float lerpHeadRot = Mth.rotLerp((float)partialTick, (float)entity.yHeadRotO, (float)entity.yHeadRot);
        float netHeadYaw = lerpHeadRot - lerpBodyRot;
        if (shouldSit && (entity2 = entity.getVehicle()) instanceof LivingEntity) {
            LivingEntity livingVehicle = (LivingEntity)entity2;
            lerpBodyRot = Mth.rotLerp((float)partialTick, (float)livingVehicle.yBodyRotO, (float)livingVehicle.yBodyRot);
            netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = Mth.clamp((float)Mth.wrapDegrees((float)netHeadYaw), (float)-85.0f, (float)85.0f);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
            netHeadYaw = lerpHeadRot - lerpBodyRot;
        }
        return -netHeadYaw;
    }

    private static float computeHeadPitch(LivingEntity entity, float partialTick) {
        return -Mth.lerp((float)partialTick, (float)entity.xRotO, (float)entity.getXRot());
    }

    private BasicAnimationUtils() {
        throw new UnsupportedOperationException();
    }
}

