/*
 * Decompiled with CFR 0.152.
 */
package com.avp.client.input.keybind;

import com.avp.client.model.KeyInteractType;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;

public class KeyPressHandler {
    private static final HashSet<KeyMapping> PRESSED_KEYS = new HashSet();

    public static void handle(KeyMapping keyMapping, Consumer<KeyInteractType> keyInteractTypeConsumer) {
        if (!PRESSED_KEYS.contains(keyMapping) && keyMapping.isDown()) {
            PRESSED_KEYS.add(keyMapping);
            keyInteractTypeConsumer.accept(KeyInteractType.PRESS);
            return;
        }
        if (!keyMapping.isDown() && PRESSED_KEYS.contains(keyMapping)) {
            keyInteractTypeConsumer.accept(KeyInteractType.RELEASE);
            PRESSED_KEYS.remove(keyMapping);
        }
    }
}

