/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.config;

import mod.azure.azurelib.common.api.common.config.Config;
import mod.azure.azurelib.common.internal.common.config.Configurable;

@Config(id="avp")
public class AVPConfig {
    @Configurable
    @Configurable.Synchronized
    @Configurable.Comment(value={"Controls the settings of the various blocks"})
    public BlockConfigs blockConfigs = new BlockConfigs();
    @Configurable
    @Configurable.Synchronized
    @Configurable.Comment(value={"Controls the Mobs Spawn Settings"})
    public SpawnConfigs spawnConfigs = new SpawnConfigs();
    @Configurable
    @Configurable.Synchronized
    @Configurable.Comment(value={"Controls the Mobs Stats"})
    public StatsConfigs statsConfigs = new StatsConfigs();
    @Configurable
    @Configurable.Synchronized
    @Configurable.Comment(value={"Controls the Hive Settings"})
    public HiveConfigs hiveConfigs = new HiveConfigs();
    @Configurable
    @Configurable.Synchronized
    public WeaponConfigs weaponConfigs = new WeaponConfigs();

    public static class BlockConfigs {
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Resonator will replace every time this value is met", "1 second is 20 ticks. Default of 30 seconds"})
        public int RESONATOR_REPLACE_TICKS = 600;
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Radius in blocks a Resonator will look for resin blocks"})
        public int RESONATOR_REPLACE_RADIUS = 25;
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"If enabled, nukes will explode."})
        public boolean ENABLE_NUKE_BLOCK_MECHS = false;
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"FOV range that turrets can target"})
        public int TURRET_FOV = 45;
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Block range that turrets can target"})
        public int TURRET_RANGE = 32;
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Turret damage value"})
        public float TURRET_DAMAGE = 2.0f;
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Block radius that a turret looks for an ammo chest"})
        public int TURRET_AMMO_CHEST_SEARCH_RANGE = 5;
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Block radius that a trip mine looks for a living entity"})
        public double TRIP_MINE_SEARCH_RADIUS = 2.0;
    }

    public static class SpawnConfigs {
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Modifying these will require restarting the game."})
        public SpawnSettings ABERRANT_CHESTBURSTER_SPAWN = new SpawnSettings(true, 1, 2, 10);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Aberrant Crusher spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings ABERRANT_CRUSHER_SPAWN = new SpawnSettings(true, 1, 1, 10);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Modifying these will require restarting the game."})
        public SpawnSettings ABERRANT_DRONE_SPAWN = new SpawnSettings(true, 1, 2, 50);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Aberrant Praetorian spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings ABERRANT_PRAETORIAN_SPAWN = new SpawnSettings(true, 1, 1, 10);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Aberrant Prowler spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings ABERRANT_PROWLER_SPAWN = new SpawnSettings(true, 1, 2, 25);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Aberrant Queen spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings ABERRANT_QUEEN_SPAWN = new SpawnSettings(true, 1, 1, 5);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Modifying these will require restarting the game."})
        public SpawnSettings ABERRANT_RUNNER_SPAWN = new SpawnSettings(true, 1, 2, 50);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Aberrant Spitter spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings ABERRANT_SPITTER_SPAWN = new SpawnSettings(true, 1, 2, 15);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Aberrant Warrior spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings ABERRANT_WARRIOR_SPAWN = new SpawnSettings(true, 1, 2, 25);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Modifying these will require restarting the game."})
        public SpawnSettings CHESTBURSTER_SPAWN = new SpawnSettings(true, 1, 2, 10);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Crusher spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings CRUSHER_SPAWN = new SpawnSettings(true, 1, 1, 10);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Modifying these will require restarting the game."})
        public SpawnSettings DRONE_SPAWN = new SpawnSettings(true, 1, 2, 50);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Irradiated Crusher spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings IRRADIATED_CRUSHER_SPAWN = new SpawnSettings(true, 1, 1, 10);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Irradiated Drone spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings IRRADIATED_DRONE_SPAWN = new SpawnSettings(true, 1, 2, 50);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Irradiated Praetorian spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings IRRADIATED_PRAETORIAN_SPAWN = new SpawnSettings(true, 1, 1, 10);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Irradiated Prowler spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings IRRADIATED_PROWLER_SPAWN = new SpawnSettings(true, 1, 2, 25);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Irradiated Queen spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings IRRADIATED_QUEEN_SPAWN = new SpawnSettings(true, 1, 1, 5);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Irradiated Runner spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings IRRADIATED_RUNNER_SPAWN = new SpawnSettings(true, 1, 2, 50);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Irradiated Warrior spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings IRRADIATED_WARRIOR_SPAWN = new SpawnSettings(true, 1, 2, 25);
        public SpawnSettings MARINE_SPAWN = new SpawnSettings(true, 1, 1, 1);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Modifying these will require restarting the game."})
        public SpawnSettings NETHER_CHESTBURSTER_SPAWN = new SpawnSettings(true, 1, 2, 10);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Nether Crusher spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings NETHER_CRUSHER_SPAWN = new SpawnSettings(true, 1, 1, 10);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Modifying these will require restarting the game."})
        public SpawnSettings NETHER_DRONE_SPAWN = new SpawnSettings(true, 1, 2, 50);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Nether Praetorian spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings NETHER_PRAETORIAN_SPAWN = new SpawnSettings(true, 1, 1, 10);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Nether Prowler spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings NETHER_PROWLER_SPAWN = new SpawnSettings(true, 1, 2, 25);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Nether Queen spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings NETHER_QUEEN_SPAWN = new SpawnSettings(true, 1, 1, 5);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Modifying these will require restarting the game."})
        public SpawnSettings NETHER_RUNNER_SPAWN = new SpawnSettings(true, 1, 2, 50);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Nether Spitter spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings NETHER_SPITTER_SPAWN = new SpawnSettings(true, 1, 2, 15);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Nether Warrior spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings NETHER_WARRIOR_SPAWN = new SpawnSettings(true, 1, 2, 25);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Praetorian spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings PRAETORIAN_SPAWN = new SpawnSettings(true, 1, 1, 10);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Prowler spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings PROWLER_SPAWN = new SpawnSettings(true, 1, 2, 25);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Queen spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings QUEEN_SPAWN = new SpawnSettings(true, 1, 1, 5);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Modifying these will require restarting the game."})
        public SpawnSettings RUNNER_SPAWN = new SpawnSettings(true, 1, 2, 50);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Spitter spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings SPITTER_SPAWN = new SpawnSettings(true, 1, 2, 15);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Warrior spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings WARRIOR_SPAWN = new SpawnSettings(true, 1, 2, 25);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Yautja spawn settings. Modifying these will require restarting the game."})
        public SpawnSettings YAUTJA_SPAWN = new SpawnSettings(true, 1, 1, 10);

        public static class SpawnSettings {
            @Configurable
            @Configurable.Synchronized
            @Configurable.Comment(value={"If true, spawning is enabled."})
            public boolean enabled;
            @Configurable
            @Configurable.Synchronized
            @Configurable.Comment(value={"The minimum group size for this entity's spawn."})
            public int minGroupSize;
            @Configurable
            @Configurable.Synchronized
            @Configurable.Comment(value={"The maximum group size for this entity's spawn."})
            public int maxGroupSize;
            @Configurable
            @Configurable.Synchronized
            @Configurable.Comment(value={"The spawn weight for this entity."})
            public int weight;

            public SpawnSettings(boolean enabled, int minGroupSize, int maxGroupSize, int weight) {
                this.enabled = enabled;
                this.minGroupSize = minGroupSize;
                this.maxGroupSize = maxGroupSize;
                this.weight = weight;
            }
        }
    }

    public static class StatsConfigs {
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Aberrant stats multiplier."})
        public float ABERRANT_STATS_MULTIPLIER = 0.9f;
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Irradiated stats multiplier."})
        public float IRRADIATED_STATS_MULTIPLIER = 1.2f;
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"The acid stats for attack damage."})
        public float ACID_ATTACK_DAMAGE = 1.0f;
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Modifying any of these will require restarting the game."})
        public AdvancedStats ADOLESCENT_STATS = new AdvancedStats(10.0f, 2.0f, 0.5f, 0.0f, 0.32287502f, 0.0f, 0.0f, 750, 16.0f);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Modifying any of these will require restarting the game."})
        public AdvancedStats BOILER_STATS = new AdvancedStats(40.0f, 5.0f, 0.5f, 0.3f, 0.31500003f, 2.0f, 0.0f, 20, 16.0f);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Modifying any of these will require restarting the game."})
        public AdvancedStats FACEHUGGER_STATS = new AdvancedStats(3.0f, 0.0f, 0.0f, 0.0f, 0.34650004f, 0.0f, 0.0f, 0, 35.0f);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Modifying any of these will require restarting the game."})
        public AdvancedStats CHESTBURSTER_STATS = new AdvancedStats(5.0f, 2.0f, 0.5f, 0.0f, 0.33075002f, 0.0f, 0.0f, 750, 16.0f);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Modifying any of these will require restarting the game."})
        public AdvancedStats CRUSHER_STATS = new AdvancedStats(100.0f, 15.0f, 0.5f, 0.7f, 0.37800005f, 12.0f, 12.0f, 80, 35.0f);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Modifying any of these will require restarting the game."})
        public AdvancedStats DRONE_STATS = new AdvancedStats(40.0f, 5.0f, 0.5f, 0.3f, 0.31500003f, 4.0f, 0.0f, 20, 35.0f);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Modifying any of these will require restarting the game."})
        public AdvancedStats OVOMORPH_STATS = new AdvancedStats(30.0f, 0.0f, 0.5f, 1.0f, 0.0f, 0.0f, 0.0f, 0, 0.0f);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Modifying any of these will require restarting the game."})
        public AdvancedStats PRAETORIAN_STATS = new AdvancedStats(100.0f, 15.0f, 0.5f, 0.7f, 0.37800005f, 12.0f, 12.0f, 80, 35.0f);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Modifying any of these will require restarting the game."})
        public AdvancedStats PROWLER_STATS = new AdvancedStats(60.0f, 10.0f, 0.5f, 0.5f, 0.34650004f, 8.0f, 0.0f, 40, 35.0f);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Modifying any of these will require restarting the game."})
        public AdvancedStats QUEEN_STATS = new AdvancedStats(200.0f, 50.0f, 0.5f, 1.0f, 0.28350002f, 16.0f, 16.0f, 10, 35.0f);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Modifying any of these will require restarting the game."})
        public AdvancedStats RUNNER_STATS = new AdvancedStats(40.0f, 5.0f, 0.5f, 0.3f, 0.31500003f, 4.0f, 0.0f, 20, 35.0f);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Modifying any of these will require restarting the game."})
        public AdvancedStats SPITTER_STATS = new AdvancedStats(60.0f, 10.0f, 0.5f, 0.5f, 0.34650004f, 8.0f, 0.0f, 20, 35.0f);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Modifying any of these will require restarting the game."})
        public AdvancedStats WARRIOR_STATS = new AdvancedStats(60.0f, 10.0f, 0.5f, 0.5f, 0.34650004f, 8.0f, 0.0f, 40, 35.0f);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Modifying any of these will require restarting the game."})
        public AdvancedStats YAUTJA_STATS = new AdvancedStats(200.0f, 15.0f, 0.0f, 1.0f, 0.37800005f, 16.0f, 16.0f, 0, 35.0f);
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Modifying any of these will require restarting the game."})
        public AdvancedStats MARINE_STATS = new AdvancedStats(20.0f, 2.0f, 0.0f, 0.0f, 0.41658753f, 2.0f, 0.0f, 0, 20.0f);

        public static class AdvancedStats {
            @Configurable
            @Configurable.Synchronized
            @Configurable.Comment(value={"The entity's health."})
            public float health;
            @Configurable
            @Configurable.Synchronized
            @Configurable.Comment(value={"The entity's attack damage."})
            public float attackDamage;
            @Configurable
            @Configurable.Synchronized
            @Configurable.Comment(value={"The amount of health the entity regenerates per second."})
            public float healthRegenPerSecond;
            @Configurable
            @Configurable.Synchronized
            @Configurable.Comment(value={"The entity's knockback resistance."})
            public float knockbackResistance;
            @Configurable
            @Configurable.Synchronized
            @Configurable.Comment(value={"The entity's movement speed."})
            public float moveSpeed;
            @Configurable
            @Configurable.Synchronized
            @Configurable.Comment(value={"The entity's armor value."})
            public float armor;
            @Configurable
            @Configurable.Synchronized
            @Configurable.Comment(value={"The entity's armor toughness."})
            public float armorToughness;
            @Configurable
            @Configurable.Synchronized
            @Configurable.Comment(value={"The entity's nest tick rate."})
            public int nestTickrate;
            @Configurable
            @Configurable.Synchronized
            @Configurable.Comment(value={"The entity's max follow range."})
            public float followRange;

            public AdvancedStats(float health, float attackDamage, float healthRegenPerSecond, float knockbackResistance, float moveSpeed, float armor, float armorToughness, int nestTickrate, float followRange) {
                this.health = health;
                this.attackDamage = attackDamage;
                this.healthRegenPerSecond = healthRegenPerSecond;
                this.knockbackResistance = knockbackResistance;
                this.moveSpeed = moveSpeed;
                this.armor = armor;
                this.nestTickrate = nestTickrate;
                this.armorToughness = armorToughness;
                this.followRange = followRange;
            }
        }
    }

    public static class HiveConfigs {
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"The minimum distance between natural queen spawns in chunks."})
        public int MINIMUM_DISTANCE_BETWEEN_NATURAL_QUEEN_SPAWNS_IN_CHUNKS = 16;
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"The minimum distance between hive centers in blocks. This controls how far apart hives are.", "If this value is less than 2x the hive radius, hives will begin to overlap.", "If this value is more than 2x the hive radius, then there will be buffer zones between hives where no hives will form."})
        public int HIVE_RADIUS_IN_BLOCKS = 64;
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"The maximum distance away from a hive that xenomorphs are allowed to join or remain as a member of a hive."})
        public int HIVE_LEASH_RADIUS_IN_BLOCKS = 98;
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"The maximum number of praetorians allowed within a hive."})
        public int HIVE_MAX_PRAETORIAN_COUNT = 6;
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"The number of hive members required for a single praetorian to appear.", "For example, if set to 8, then there will be a praetorian for every 8 hive members."})
        public int HIVE_MEMBERS_REQUIRED_FOR_PRAETORIAN = 8;
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Determines if the screen should darken when the hive boss bar appears."})
        public boolean HIVE_DARKEN_SCREEN = true;
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Enables hive debugging."})
        public boolean HIVE_DEBUG_ENABLED = false;
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Requires hive debugging to be enabled."})
        public boolean HIVE_DEBUG_HIGHLIGHT_LEADER = true;
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"Requires hive debugging to be enabled."})
        public boolean HIVE_DEBUG_HIGHLIGHT_ALL_MEMBERS = false;
    }

    public static class WeaponConfigs {
        @Configurable
        @Configurable.Synchronized
        @Configurable.Comment(value={"If enabled, bullets from guns will damage blocks."})
        public boolean BULLETS_DAMAGE_BLOCKS_ENABLED = true;
    }
}

