/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.ai.goal;

import com.avp.common.registry.tag.AVPBlockTags;
import com.avp.server.BlockBreakProgressManager;
import com.human.common.registry.init.block.HumanSteelBlocks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class DigToTargetGoal
extends Goal {
    private static final float BREAKING_SPEED = 50.0f;
    private final Mob mob;
    private final double reachDistance;
    private final double maxDistanceFromTarget;
    private final List<BlockPos> targetBlockPositions = new ArrayList<BlockPos>();
    private final int parallelBlockBreakCount;
    private final Supplier<Boolean> canDig;
    private BlockState blockState = null;
    private Vec3 lastPosition = null;
    private int lastProgressTick = 0;
    private double lastDistanceToTarget = Double.MAX_VALUE;

    public DigToTargetGoal(Mob mob) {
        this(mob, 16.0, () -> true);
    }

    public DigToTargetGoal(Mob mob, double maxDistanceFromTarget, Supplier<Boolean> canDig) {
        this(mob, maxDistanceFromTarget, 1, canDig);
    }

    public DigToTargetGoal(Mob mob, double maxDistanceFromTarget, int parallelBlockBreakCount, Supplier<Boolean> canDig) {
        this.mob = mob;
        this.reachDistance = 4.0;
        this.maxDistanceFromTarget = maxDistanceFromTarget * maxDistanceFromTarget;
        this.parallelBlockBreakCount = parallelBlockBreakCount;
        this.canDig = canDig;
    }

    public boolean canUse() {
        if (!this.canDig.get().booleanValue()) {
            return false;
        }
        LivingEntity target = this.mob.getTarget();
        if (target == null || !this.mob.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            return false;
        }
        if (this.mob.getHealth() < this.mob.getMaxHealth() / 2.0f) {
            return false;
        }
        return this.mob.onGround() && this.isStuck(target) && (this.mob.distanceToSqr((Entity)target) > 2.0 || !this.mob.getSensing().hasLineOfSight((Entity)target)) && this.mob.distanceToSqr((Entity)target) < this.maxDistanceFromTarget;
    }

    public boolean canContinueToUse() {
        if (!this.canDig.get().booleanValue()) {
            return false;
        }
        LivingEntity target = this.mob.getTarget();
        if (target == null || !target.isAlive() || this.targetBlockPositions.isEmpty()) {
            return false;
        }
        if (this.mob.getHealth() < this.mob.getMaxHealth() / 2.0f) {
            return false;
        }
        return this.mob.onGround() && !this.mob.level().getBlockState(this.targetBlockPositions.getFirst()).isAir() && this.targetBlockPositions.getFirst().distSqr((Vec3i)this.mob.blockPosition()) < this.reachDistance * this.reachDistance;
    }

    public void start() {
        LivingEntity target = this.mob.getTarget();
        if (target == null) {
            return;
        }
        this.gatherTargetBlocks(target);
        if (!this.targetBlockPositions.isEmpty()) {
            this.initBlockBreak();
            this.mob.setAggressive(true);
        }
    }

    public void stop() {
        if (!this.targetBlockPositions.isEmpty()) {
            this.targetBlockPositions.clear();
        }
        this.blockState = null;
        this.lastPosition = null;
        this.mob.setAggressive(false);
    }

    public void tick() {
        LivingEntity target = this.mob.getTarget();
        if (target == null || this.targetBlockPositions.isEmpty()) {
            return;
        }
        if (this.mob.tickCount % 4 == 0) {
            for (int i = 0; i < this.targetBlockPositions.size() && i < this.parallelBlockBreakCount; ++i) {
                this.breakBlockAtPosition(this.targetBlockPositions.get(i), target);
            }
        }
    }

    private void breakBlockAtPosition(BlockPos pos, LivingEntity target) {
        this.mob.getLookControl().setLookAt((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
        BlockBreakProgressManager.damage(this.mob.level(), pos, 50.0f);
        SoundType soundType = this.blockState.getSoundType();
        this.mob.level().playSound(null, pos, soundType.getHitSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 8.0f, soundType.getPitch() * 0.5f);
        if (this.mob.level().getBlockState(pos).is(Blocks.AIR)) {
            this.targetBlockPositions.removeFirst();
            if (!this.targetBlockPositions.isEmpty()) {
                this.initBlockBreak();
            } else if (this.mob.distanceToSqr((Entity)target) > 2.0 && !this.mob.getSensing().hasLineOfSight((Entity)target)) {
                this.start();
            }
        }
    }

    private void initBlockBreak() {
        this.blockState = this.mob.level().getBlockState(this.targetBlockPositions.getFirst());
    }

    private void gatherTargetBlocks(@NotNull LivingEntity target) {
        int mobWidth = Mth.ceil((float)this.mob.getBbWidth());
        int mobHeight = Mth.ceil((float)this.mob.getBbHeight());
        for (int i = 0; i < mobHeight; ++i) {
            for (int j = -mobWidth / 2; j <= mobWidth / 2; ++j) {
                for (int k = -mobWidth / 2; k <= mobWidth / 2; ++k) {
                    BlockState state;
                    double distance;
                    Vec3 from = this.mob.position().add((double)j, (double)i + 0.5, (double)k);
                    Vec3 to = target.getEyePosition(1.0f).add((double)j, (double)i, (double)k);
                    ClipContext clipContext = new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.mob);
                    BlockHitResult rayTraceResult = this.mob.level().clip(clipContext);
                    if (rayTraceResult.getType() == HitResult.Type.MISS || this.targetBlockPositions.contains(rayTraceResult.getBlockPos()) || rayTraceResult.getBlockPos().getY() > 320 || (distance = this.mob.distanceToSqr(rayTraceResult.getLocation())) > this.reachDistance * this.reachDistance || (state = this.mob.level().getBlockState(rayTraceResult.getBlockPos())).hasBlockEntity() || state.getDestroySpeed((BlockGetter)this.mob.level(), rayTraceResult.getBlockPos()) == -1.0f || state.getBlock().defaultDestroyTime() >= HumanSteelBlocks.STEEL_BLOCK.get().defaultDestroyTime() || state.is(AVPBlockTags.XENOMORPH_IMMUNE)) continue;
                    this.targetBlockPositions.add(rayTraceResult.getBlockPos());
                }
            }
        }
        Collections.reverse(this.targetBlockPositions);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean isStuck(@NotNull LivingEntity target) {
        double currentDistanceToTarget = this.mob.distanceToSqr((Entity)target);
        if (currentDistanceToTarget <= (double)(this.mob.getBbWidth() * this.mob.getBbWidth())) {
            this.resetProgress();
            return false;
        }
        if (this.lastPosition == null) {
            this.lastPosition = this.mob.position();
            this.lastProgressTick = this.mob.tickCount;
            this.lastDistanceToTarget = currentDistanceToTarget;
            return false;
        }
        if (currentDistanceToTarget < this.lastDistanceToTarget - 0.5) {
            this.lastPosition = this.mob.position();
            this.lastProgressTick = this.mob.tickCount;
            this.lastDistanceToTarget = currentDistanceToTarget;
            return false;
        }
        return this.mob.tickCount - this.lastProgressTick >= 4;
    }

    private void resetProgress() {
        this.lastPosition = null;
        this.lastProgressTick = 0;
        this.lastDistanceToTarget = Double.MAX_VALUE;
    }
}

