/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.ai.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class XenoFloatGoal
extends FloatGoal {
    private Mob mob;
    private BlockPos targetPos;

    public XenoFloatGoal(Mob mob) {
        super(mob);
        this.mob = mob;
    }

    public boolean canUse() {
        BlockPos blockPos = this.mob.blockPosition();
        BlockPos belowPos = blockPos.below();
        BlockState belowState = this.mob.level().getBlockState(belowPos);
        if (this.mob.isAggressive()) {
            return false;
        }
        if (!this.mob.isInWater()) {
            return false;
        }
        if (!belowState.isSolidRender((BlockGetter)this.mob.level(), belowPos)) {
            return false;
        }
        if (this.targetPos == null) {
            return false;
        }
        this.targetPos = this.findNonWaterBlock(blockPos);
        return this.targetPos != null;
    }

    public void tick() {
        if (this.targetPos != null) {
            Vec3 deltaMovement = this.mob.getDeltaMovement().scale(0.2);
            Vec3 vectorToTarget = this.mob.position().vectorTo(this.targetPos.getCenter()).normalize().scale(0.2).add(deltaMovement.x, 0.0, deltaMovement.z);
            this.mob.setDeltaMovement(vectorToTarget.x, Math.max(0.6, vectorToTarget.y), vectorToTarget.z);
        }
    }

    private BlockPos findNonWaterBlock(BlockPos centerPos) {
        Level level = this.mob.level();
        for (int x = -5; x <= 5; ++x) {
            for (int y = -5; y <= 5; ++y) {
                for (int z = -5; z <= 5; ++z) {
                    BlockPos currentPos = centerPos.offset(x, y, z);
                    BlockState blockState = level.getBlockState(currentPos);
                    if (blockState.isAir() || !blockState.isSolidRender((BlockGetter)level, currentPos)) continue;
                    return currentPos;
                }
            }
        }
        return null;
    }
}

