/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.ai.goal.combat;

import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LungeAtTargetGoal
extends Goal {
    private static final int DEFAULT_WIND_UP_TIME_IN_TICKS = 10;
    private static final float DEFAULT_DISTANCE_TARGET = -1.0f;
    private final Mob mob;
    private final int maxCooldown;
    private final float normalizedChance;
    private final double minLungeRange;
    private final double maxLungeRange;
    private float distanceToTarget;
    private int windUpTimeInTicks;
    private int cooldown;
    @Nullable
    Runnable onLungeCallback;

    public LungeAtTargetGoal(Mob mob, float normalizedChance, int cooldown, double minLungeRange, double maxLungeRange) {
        this.mob = mob;
        this.maxCooldown = cooldown;
        this.normalizedChance = normalizedChance;
        this.minLungeRange = minLungeRange;
        this.maxLungeRange = maxLungeRange;
        this.cooldown = 0;
        this.resetWindUpTimeInTicks();
        this.distanceToTarget = -1.0f;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        this.cooldown = Math.max(this.cooldown - 1, 0);
        boolean canUse = !this.isOnCooldown() && this.mob.getRandom().nextFloat() < this.normalizedChance;
        return this.mob.getTarget() != null && this.mob.onGround() && this.isInRange() && canUse && this.mob.getSensing().hasLineOfSight((Entity)this.mob.getTarget());
    }

    public boolean canContinueToUse() {
        return this.mob.getTarget() != null && this.mob.onGround() && this.mob.getSensing().hasLineOfSight((Entity)this.mob.getTarget());
    }

    public void start() {
        super.start();
        LivingEntity target = this.mob.getTarget();
        if (target != null) {
            this.mob.lookAt(EntityAnchorArgument.Anchor.EYES, target.getEyePosition());
            this.mob.getLookControl().setLookAt((Entity)target);
        }
    }

    public void tick() {
        LivingEntity target = this.mob.getTarget();
        if (target == null) {
            return;
        }
        this.mob.lookAt(EntityAnchorArgument.Anchor.EYES, target.getEyePosition());
        this.mob.getLookControl().setLookAt((Entity)target);
        float currentDistanceToTarget = this.mob.distanceTo((Entity)target);
        if (this.distanceToTarget == -1.0f) {
            this.distanceToTarget = currentDistanceToTarget;
        }
        if (this.mob.getLastHurtByMobTimestamp() > 0 && this.mob.tickCount - this.mob.getLastHurtByMobTimestamp() < 20 || currentDistanceToTarget > this.distanceToTarget) {
            this.windUpTimeInTicks = 0;
        }
        if (this.windUpTimeInTicks > 0) {
            --this.windUpTimeInTicks;
            this.mob.getNavigation().stop();
            return;
        }
        this.distanceToTarget = currentDistanceToTarget;
        Vec3 deltaMovement = this.mob.getDeltaMovement().scale(0.2);
        Vec3 vectorDifference = target.getEyePosition().subtract(this.mob.getEyePosition());
        vectorDifference = vectorDifference.normalize().scale(0.2 * (double)this.distanceToTarget).add(deltaMovement.x, 0.0, deltaMovement.z);
        this.mob.setDeltaMovement(vectorDifference.x, Math.max(0.6, vectorDifference.y), vectorDifference.z);
        if (this.onLungeCallback != null) {
            this.onLungeCallback.run();
        }
        this.resetWindUpTimeInTicks();
        this.resetCooldown();
    }

    public void stop() {
        super.stop();
        this.resetCooldown();
        this.resetWindUpTimeInTicks();
        this.distanceToTarget = -1.0f;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public LungeAtTargetGoal setOnLungeCallback(@Nullable Runnable onLungeCallback) {
        this.onLungeCallback = onLungeCallback;
        return this;
    }

    private boolean isOnCooldown() {
        return this.cooldown > 0;
    }

    private void resetCooldown() {
        this.cooldown = this.maxCooldown;
    }

    private void resetWindUpTimeInTicks() {
        this.windUpTimeInTicks = 10;
    }

    private boolean isInRange() {
        boolean isTargetTooFarAwayVertically;
        boolean isTargetTooFarAwayHorizontally;
        LivingEntity target = this.mob.getTarget();
        if (target == null) {
            return false;
        }
        double dx = this.mob.getX() - target.getX();
        double dz = this.mob.getZ() - target.getZ();
        double horizontalDistanceSqr = dx * dx + dz * dz;
        double minimumRangeSquared = this.minLungeRange * this.minLungeRange;
        double maximumRangeSquared = this.maxLungeRange * this.maxLungeRange;
        boolean bl = isTargetTooFarAwayHorizontally = horizontalDistanceSqr > maximumRangeSquared;
        if (isTargetTooFarAwayHorizontally) {
            return false;
        }
        double dy = Math.abs(this.mob.getY() - target.getY());
        double verticalDistanceSqr = dy * dy;
        boolean bl2 = isTargetTooFarAwayVertically = verticalDistanceSqr > maximumRangeSquared;
        if (isTargetTooFarAwayVertically) {
            return false;
        }
        float minVerticalLungeRange = this.mob.getBbHeight() * this.mob.getBbHeight();
        boolean isTargetTooCloseHorizontally = horizontalDistanceSqr < minimumRangeSquared;
        boolean isTargetTooCloseVertically = dy <= (double)minVerticalLungeRange;
        return !isTargetTooCloseHorizontally || !isTargetTooCloseVertically;
    }
}

