/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.block.property;

import com.just.core.functional.option.Option;
import java.util.function.ToIntFunction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public class BlockPropertyBuilder {
    private final Option<BlockBehaviour> blockBehaviourOption;
    private Option<Float> explosionResistanceOption;
    private Option<Boolean> forceSolidOnOption;
    private Option<Boolean> forceSolidOffOption;
    private Option<Float> frictionOption;
    private Option<NoteBlockInstrument> instrumentOption;
    private Option<BlockBehaviour.StatePredicate> isRedstoneConductorOption;
    private Option<BlockBehaviour.StatePredicate> isSuffocatingOption;
    private Option<BlockBehaviour.StateArgumentPredicate<EntityType<?>>> isValidSpawnOption;
    private Option<BlockBehaviour.StatePredicate> isViewBlockingOption;
    private Option<ToIntFunction<BlockState>> lightLevelOption;
    private Option<MapColor> mapColorOption;
    private Option<Boolean> noCollisionOption;
    private Option<Boolean> noOcclusionOption;
    private Option<PushReaction> pushReactionOption;
    private Option<Boolean> randomTicksOption;
    private Option<Boolean> replaceableOption;
    private Option<Boolean> requiresCorrectToolForDropsOption;
    private Option<SoundType> soundTypeOption;
    private Option<Float> strengthOption;

    public static BlockPropertyBuilder inherit(BlockBehaviour blockBehaviour) {
        return new BlockPropertyBuilder(blockBehaviour);
    }

    public static BlockPropertyBuilder of() {
        return new BlockPropertyBuilder();
    }

    private BlockPropertyBuilder() {
        this(null);
    }

    private BlockPropertyBuilder(@Nullable BlockBehaviour blockBehaviour) {
        this((Option<BlockBehaviour>)Option.ofNullable((Object)blockBehaviour), (Option<Float>)Option.none(), (Option<Boolean>)Option.none(), (Option<Boolean>)Option.none(), (Option<Float>)Option.none(), (Option<NoteBlockInstrument>)Option.none(), (Option<BlockBehaviour.StatePredicate>)Option.none(), (Option<BlockBehaviour.StatePredicate>)Option.none(), (Option<BlockBehaviour.StateArgumentPredicate<EntityType<?>>>)Option.none(), (Option<BlockBehaviour.StatePredicate>)Option.none(), (Option<ToIntFunction<BlockState>>)Option.none(), (Option<MapColor>)Option.none(), (Option<Boolean>)Option.none(), (Option<Boolean>)Option.none(), (Option<PushReaction>)Option.none(), (Option<Boolean>)Option.none(), (Option<Boolean>)Option.none(), (Option<Boolean>)Option.none(), (Option<SoundType>)Option.none(), (Option<Float>)Option.none());
    }

    private BlockPropertyBuilder(Option<BlockBehaviour> blockBehaviourOption, Option<Float> explosionResistanceOption, Option<Boolean> forceSolidOnOption, Option<Boolean> forceSolidOffOption, Option<Float> frictionOption, Option<NoteBlockInstrument> instrumentOption, Option<BlockBehaviour.StatePredicate> isRedstoneConductorOption, Option<BlockBehaviour.StatePredicate> isSuffocatingOption, Option<BlockBehaviour.StateArgumentPredicate<EntityType<?>>> isValidSpawnOption, Option<BlockBehaviour.StatePredicate> isViewBlockingOption, Option<ToIntFunction<BlockState>> lightLevelOption, Option<MapColor> mapColorOption, Option<Boolean> noCollisionOption, Option<Boolean> noOcclusionOption, Option<PushReaction> pushReactionOption, Option<Boolean> randomTicksOption, Option<Boolean> replaceableOption, Option<Boolean> requiresCorrectToolForDropsOption, Option<SoundType> soundTypeOption, Option<Float> strengthOption) {
        this.blockBehaviourOption = blockBehaviourOption;
        this.explosionResistanceOption = explosionResistanceOption;
        this.forceSolidOnOption = forceSolidOnOption;
        this.forceSolidOffOption = forceSolidOffOption;
        this.frictionOption = frictionOption;
        this.instrumentOption = instrumentOption;
        this.isRedstoneConductorOption = isRedstoneConductorOption;
        this.isSuffocatingOption = isSuffocatingOption;
        this.isValidSpawnOption = isValidSpawnOption;
        this.isViewBlockingOption = isViewBlockingOption;
        this.lightLevelOption = lightLevelOption;
        this.mapColorOption = mapColorOption;
        this.noCollisionOption = noCollisionOption;
        this.noOcclusionOption = noOcclusionOption;
        this.pushReactionOption = pushReactionOption;
        this.randomTicksOption = randomTicksOption;
        this.replaceableOption = replaceableOption;
        this.requiresCorrectToolForDropsOption = requiresCorrectToolForDropsOption;
        this.soundTypeOption = soundTypeOption;
        this.strengthOption = strengthOption;
    }

    public BlockPropertyBuilder explosionResistance(float explosionResistance) {
        BlockPropertyBuilder copy = this.copy();
        copy.explosionResistanceOption = Option.some((Object)Float.valueOf(explosionResistance));
        return copy;
    }

    public BlockPropertyBuilder forceSolidOn() {
        BlockPropertyBuilder copy = this.copy();
        copy.forceSolidOnOption = Option.some((Object)true);
        return copy;
    }

    public BlockPropertyBuilder forceSolidOff() {
        BlockPropertyBuilder copy = this.copy();
        copy.forceSolidOffOption = Option.some((Object)true);
        return copy;
    }

    public BlockPropertyBuilder friction(float friction) {
        BlockPropertyBuilder copy = this.copy();
        copy.frictionOption = Option.some((Object)Float.valueOf(friction));
        return copy;
    }

    public BlockPropertyBuilder instrument(NoteBlockInstrument instrument) {
        BlockPropertyBuilder copy = this.copy();
        copy.instrumentOption = Option.some((Object)instrument);
        return copy;
    }

    public BlockPropertyBuilder isRedstoneConductor(BlockBehaviour.StatePredicate predicate) {
        BlockPropertyBuilder copy = this.copy();
        copy.isRedstoneConductorOption = Option.some((Object)predicate);
        return copy;
    }

    public BlockPropertyBuilder isSuffocating(BlockBehaviour.StatePredicate predicate) {
        BlockPropertyBuilder copy = this.copy();
        copy.isSuffocatingOption = Option.some((Object)predicate);
        return copy;
    }

    public BlockPropertyBuilder isValidSpawn(BlockBehaviour.StateArgumentPredicate<EntityType<?>> predicate) {
        BlockPropertyBuilder copy = this.copy();
        copy.isValidSpawnOption = Option.some(predicate);
        return copy;
    }

    public BlockPropertyBuilder isViewBlocking(BlockBehaviour.StatePredicate predicate) {
        BlockPropertyBuilder copy = this.copy();
        copy.isViewBlockingOption = Option.some((Object)predicate);
        return copy;
    }

    public BlockPropertyBuilder lightLevel(ToIntFunction<BlockState> toIntFunction) {
        BlockPropertyBuilder copy = this.copy();
        copy.lightLevelOption = Option.some(toIntFunction);
        return copy;
    }

    public BlockPropertyBuilder mapColor(DyeColor dyeColor) {
        return this.mapColor(dyeColor.getMapColor());
    }

    public BlockPropertyBuilder mapColor(MapColor mapColor) {
        BlockPropertyBuilder copy = this.copy();
        copy.mapColorOption = Option.some((Object)mapColor);
        return copy;
    }

    public BlockPropertyBuilder noCollision() {
        BlockPropertyBuilder copy = this.copy();
        copy.noCollisionOption = Option.some((Object)true);
        return copy;
    }

    public BlockPropertyBuilder noOcclusion() {
        BlockPropertyBuilder copy = this.copy();
        copy.noOcclusionOption = Option.some((Object)true);
        return copy;
    }

    public BlockPropertyBuilder pushReaction(PushReaction pushReaction) {
        BlockPropertyBuilder copy = this.copy();
        copy.pushReactionOption = Option.some((Object)pushReaction);
        return copy;
    }

    public BlockPropertyBuilder randomTicks() {
        BlockPropertyBuilder copy = this.copy();
        copy.randomTicksOption = Option.some((Object)true);
        return copy;
    }

    public BlockPropertyBuilder replaceable() {
        BlockPropertyBuilder copy = this.copy();
        copy.replaceableOption = Option.some((Object)true);
        return copy;
    }

    public BlockPropertyBuilder requiresCorrectToolForDrops() {
        BlockPropertyBuilder copy = this.copy();
        copy.requiresCorrectToolForDropsOption = Option.some((Object)true);
        return copy;
    }

    public BlockPropertyBuilder sound(SoundType soundType) {
        BlockPropertyBuilder copy = this.copy();
        copy.soundTypeOption = Option.some((Object)soundType);
        return copy;
    }

    public BlockPropertyBuilder strength(float strength) {
        BlockPropertyBuilder copy = this.copy();
        copy.strengthOption = Option.some((Object)Float.valueOf(strength));
        return copy;
    }

    public BlockPropertyBuilder strength(float strength, float explosionResistance) {
        return this.strength(strength).explosionResistance(explosionResistance);
    }

    public BlockPropertyBuilder copy() {
        return new BlockPropertyBuilder(this.blockBehaviourOption, this.explosionResistanceOption, this.forceSolidOnOption, this.forceSolidOffOption, this.frictionOption, this.instrumentOption, this.isRedstoneConductorOption, this.isSuffocatingOption, this.isValidSpawnOption, this.isViewBlockingOption, this.lightLevelOption, this.mapColorOption, this.noCollisionOption, this.noOcclusionOption, this.pushReactionOption, this.randomTicksOption, this.replaceableOption, this.requiresCorrectToolForDropsOption, this.soundTypeOption, this.strengthOption);
    }

    public BlockBehaviour.Properties build() {
        BlockBehaviour.Properties baseProperties = (BlockBehaviour.Properties)this.blockBehaviourOption.map(BlockBehaviour.Properties::ofFullCopy).unwrapOr((Object)BlockBehaviour.Properties.of());
        this.explosionResistanceOption.ifSome(arg_0 -> ((BlockBehaviour.Properties)baseProperties).explosionResistance(arg_0));
        this.forceSolidOnOption.ifSome($ -> baseProperties.forceSolidOn());
        this.forceSolidOffOption.ifSome($ -> baseProperties.forceSolidOff());
        this.frictionOption.ifSome(arg_0 -> ((BlockBehaviour.Properties)baseProperties).friction(arg_0));
        this.instrumentOption.ifSome(arg_0 -> ((BlockBehaviour.Properties)baseProperties).instrument(arg_0));
        this.isSuffocatingOption.ifSome(arg_0 -> ((BlockBehaviour.Properties)baseProperties).isSuffocating(arg_0));
        this.isRedstoneConductorOption.ifSome(arg_0 -> ((BlockBehaviour.Properties)baseProperties).isRedstoneConductor(arg_0));
        this.isValidSpawnOption.ifSome(arg_0 -> ((BlockBehaviour.Properties)baseProperties).isValidSpawn(arg_0));
        this.isViewBlockingOption.ifSome(arg_0 -> ((BlockBehaviour.Properties)baseProperties).isViewBlocking(arg_0));
        this.lightLevelOption.ifSome(arg_0 -> ((BlockBehaviour.Properties)baseProperties).lightLevel(arg_0));
        this.mapColorOption.ifSome(arg_0 -> ((BlockBehaviour.Properties)baseProperties).mapColor(arg_0));
        this.noCollisionOption.ifSome($ -> baseProperties.noCollission());
        this.noOcclusionOption.ifSome($ -> baseProperties.noOcclusion());
        this.pushReactionOption.ifSome(arg_0 -> ((BlockBehaviour.Properties)baseProperties).pushReaction(arg_0));
        this.randomTicksOption.ifSome($ -> baseProperties.randomTicks());
        this.replaceableOption.ifSome($ -> baseProperties.replaceable());
        this.requiresCorrectToolForDropsOption.ifSome($ -> baseProperties.requiresCorrectToolForDrops());
        this.soundTypeOption.ifSome(arg_0 -> ((BlockBehaviour.Properties)baseProperties).sound(arg_0));
        this.strengthOption.ifSome(arg_0 -> ((BlockBehaviour.Properties)baseProperties).strength(arg_0));
        return baseProperties;
    }
}

