/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.command.count;

import com.alien.common.gameplay.level.saveddata.HiveLevelData;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;

public class CountCommand {
    private static final String COMMAND_NAME = "count";
    private static final String ENTITY_ARGUMENT_NAME = "entity";
    private static final String HIVE_ARGUMENT_NAME = "hive";

    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)COMMAND_NAME).then(Commands.argument((String)ENTITY_ARGUMENT_NAME, (ArgumentType)EntityArgument.entities()).executes(context -> {
            Collection result = EntityArgument.getEntities((CommandContext)context, (String)ENTITY_ARGUMENT_NAME);
            int count = result.size();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> {
                String areOrIs = count == 1 ? "is" : "are";
                String pluralEntity = count == 1 ? "that entity" : "those entities";
                return Component.literal((String)("There " + areOrIs + " " + count + " of " + pluralEntity + " in the world."));
            }, false);
            return 1;
        }))).then(Commands.literal((String)HIVE_ARGUMENT_NAME).executes(context -> {
            int count = (Integer)HiveLevelData.getOrCreate((Level)((CommandSourceStack)context.getSource()).getLevel()).map(hiveLevelData -> hiveLevelData.allHives().size()).unwrapOr((Object)0);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> {
                String areOrIs = count == 1 ? "is" : "are";
                String pluralHive = count == 1 ? HIVE_ARGUMENT_NAME : "hives";
                return Component.literal((String)("There " + areOrIs + " " + count + " " + pluralHive + " in the world."));
            }, false);
            return 1;
        }));
    }
}

