/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.command.nuke;

import com.avp.AVP;
import com.avp.common.gameplay.explosion.Explosion;
import com.avp.common.gameplay.explosion.ExplosionProgressTracker;
import com.avp.common.gameplay.explosion.nuke.NuclearExplosionEffects;
import com.avp.common.util.ExplosionUtil;
import com.avp.server.ServerScheduler;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.time.Duration;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class NukeCommand {
    private static final String COMMAND_NAME = "nuke";

    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        return (LiteralArgumentBuilder)Commands.literal((String)COMMAND_NAME).executes(context -> {
            ServerScheduler.schedule(() -> {
                Explosion explosion = NukeCommand.createNuclearExplosion((CommandContext<CommandSourceStack>)context);
                explosion.explode();
            }, Duration.ofSeconds(1L));
            return 1;
        });
    }

    private static Explosion createNuclearExplosion(CommandContext<CommandSourceStack> context) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        Vec3 center = ((CommandSourceStack)context.getSource()).getPosition();
        ExplosionProgressTracker progressTracker = new ExplosionProgressTracker();
        NuclearExplosionEffects nuclearExplosionEffects = new NuclearExplosionEffects();
        int radius = 128;
        int maxKnockback = 5;
        return Explosion.builder(level, center).withRadius(Direction.Plane.HORIZONTAL, radius).withRadius(Direction.UP, radius / 2).withRadius(Direction.DOWN, 32).onExplosionStart(() -> {
            progressTracker.startTimer();
            List<Entity> entities = ExplosionUtil.getEntitiesInRadius(level, center, radius);
            for (Entity entity : entities) {
                double distance = entity.distanceToSqr(center);
                double damage = ExplosionUtil.computeDamage(radius, 5.0, 1000.0, distance);
                entity.igniteForSeconds(15.0f);
                entity.hurt(level.damageSources().explosion(null), (float)damage);
                ExplosionUtil.applyKnockback(center, radius, entity, maxKnockback, distance);
            }
        }).onBlockSample(($, pos) -> {
            nuclearExplosionEffects.apply($, pos);
            progressTracker.incrementBlockDestroyCounter();
        }).onExplosionFinish(() -> {
            progressTracker.stopTimer();
            long timeTakenInMillis = progressTracker.timeTaken();
            long timeTakenInTicks = timeTakenInMillis / 50L;
            AVP.LOGGER.info("Explosion @ {} completed in {}ms ({} ticks), destroying {} blocks!", new Object[]{center, timeTakenInMillis, timeTakenInTicks, progressTracker.blocksDestroyed()});
        }).build();
    }
}

