/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.effect;

import com.avp.common.registry.init.AVPMobEffects;
import com.avp.common.registry.key.AVPDamageTypeKeys;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.avp.common.util.AVPPredicates;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import mod.azure.azurelib.core.object.Color;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class RadiationStatusEffect
extends MobEffect {
    public static final int EFFECT_DURATION_IN_TICKS = (int)TimeUnit.MINUTES.toSeconds(4L) * 20;
    private static final Map<LivingEntity, Integer> EFFECT_TRACKER = new WeakHashMap<LivingEntity, Integer>();

    public RadiationStatusEffect() {
        super(MobEffectCategory.HARMFUL, Color.GREEN.getColor());
    }

    public boolean shouldApplyEffectTickThisTick(int i, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(@NotNull LivingEntity livingEntity, int amplifier) {
        int threshold;
        if (AVPPredicates.IS_IMMORTAL.test(livingEntity) || livingEntity.getType().is(AVPEntityTypeTags.RADIATION_RESISTANT)) {
            livingEntity.removeEffect(AVPMobEffects.RADIATION.getHolder());
            return false;
        }
        Integer currentDuration = EFFECT_TRACKER.getOrDefault(livingEntity, 0);
        switch (amplifier) {
            case 0: {
                this.applyLevel1RadiationSideEffects(livingEntity, amplifier);
                break;
            }
            case 1: {
                this.applyLevel2RadiationSideEffects(livingEntity, amplifier);
                break;
            }
            default: {
                this.applyDefaultRadiationSideEffects(livingEntity, amplifier);
            }
        }
        switch (amplifier) {
            case 0: {
                int n = EFFECT_DURATION_IN_TICKS / 4;
                break;
            }
            case 1: {
                int n = EFFECT_DURATION_IN_TICKS / 2;
                break;
            }
            default: {
                int n = threshold = EFFECT_DURATION_IN_TICKS;
            }
        }
        if (currentDuration >= threshold && amplifier < 2) {
            EFFECT_TRACKER.put(livingEntity, 0);
            livingEntity.addEffect(new MobEffectInstance(AVPMobEffects.RADIATION.getHolder(), EFFECT_DURATION_IN_TICKS, amplifier + 1));
        } else {
            EFFECT_TRACKER.put(livingEntity, currentDuration + 1);
        }
        return livingEntity.isAlive();
    }

    private void applyLevel1RadiationSideEffects(LivingEntity livingEntity, int amplifier) {
        this.handleStatusEffects(livingEntity, amplifier, MobEffects.WEAKNESS, MobEffects.HUNGER);
        if (livingEntity.tickCount % 80 == 0) {
            livingEntity.hurt(RadiationStatusEffect.createRadiationDamageSource(livingEntity), 0.5f);
        }
    }

    private void applyLevel2RadiationSideEffects(LivingEntity livingEntity, int amplifier) {
        this.handleStatusEffects(livingEntity, amplifier, MobEffects.WEAKNESS, MobEffects.HUNGER, MobEffects.MOVEMENT_SLOWDOWN);
        if (livingEntity.tickCount % 40 == 0) {
            livingEntity.hurt(RadiationStatusEffect.createRadiationDamageSource(livingEntity), 1.0f);
        }
    }

    private void applyDefaultRadiationSideEffects(LivingEntity livingEntity, int amplifier) {
        this.handleStatusEffects(livingEntity, amplifier, MobEffects.WEAKNESS, MobEffects.HUNGER, MobEffects.MOVEMENT_SLOWDOWN, MobEffects.BLINDNESS);
        if (livingEntity.tickCount % 20 == 0) {
            livingEntity.hurt(RadiationStatusEffect.createRadiationDamageSource(livingEntity), 2.0f);
        }
    }

    @SafeVarargs
    private void handleStatusEffects(@NotNull LivingEntity livingEntity, int amplifier, Holder<MobEffect> ... statusEffects) {
        for (Holder<MobEffect> effect : statusEffects) {
            if (livingEntity.hasEffect(effect)) continue;
            livingEntity.addEffect(new MobEffectInstance(effect, 100, amplifier, true, true));
        }
    }

    private static DamageSource createRadiationDamageSource(LivingEntity livingEntity) {
        return new DamageSource((Holder)livingEntity.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(AVPDamageTypeKeys.RADIATION));
    }
}

