/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.entity.projectile;

import com.avp.mixin.BlockBehaviourInvoker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public abstract class BouncingItemProjectile
extends ThrowableItemProjectile {
    private static final double PERCENT_MOVEMENT_LOSS_ON_DIRECT_BOUNCE = -0.15;
    private static final double PERCENT_MOVEMENT_LOSS_ON_INDIRECT_BOUNCE = 0.5;
    protected boolean shouldBounce;
    protected int maxLife;

    protected BouncingItemProjectile(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    protected BouncingItemProjectile(EntityType<? extends ThrowableItemProjectile> entityType, double x, double y, double z, Level level) {
        super(entityType, x, y, z, level);
    }

    protected BouncingItemProjectile(EntityType<? extends ThrowableItemProjectile> entityType, LivingEntity livingEntity, Level level) {
        super(entityType, livingEntity, level);
    }

    protected void onDeath() {
    }

    public void tick() {
        super.tick();
        if (this.shouldBounce && this.tickCount >= this.maxLife) {
            this.remove(Entity.RemovalReason.KILLED);
            this.onDeath();
        }
    }

    protected void onHit(HitResult result) {
        HitResult.Type type = result.getType();
        if (type == HitResult.Type.BLOCK) {
            this.handleBlockHit(result);
        } else if (type == HitResult.Type.ENTITY) {
            this.handleEntityHit((EntityHitResult)result);
        }
    }

    private void handleEntityHit(EntityHitResult result) {
        Entity entity = result.getEntity();
        if (this.shouldBounce) {
            double speed = this.getDeltaMovement().length();
            if (speed > 0.1) {
                entity.hurt(entity.damageSources().thrown((Entity)this, this.getOwner()), 1.0f);
            }
            this.bounce(Direction.getNearest((double)this.getDeltaMovement().x(), (double)this.getDeltaMovement().y(), (double)this.getDeltaMovement().z()).getOpposite());
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.25, 0.25, 0.25));
        } else {
            this.remove(Entity.RemovalReason.KILLED);
            this.onDeath();
        }
    }

    private void handleBlockHit(HitResult result) {
        BlockHitResult blockResult = (BlockHitResult)result;
        if (!this.shouldBounce) {
            this.remove(Entity.RemovalReason.KILLED);
            this.onDeath();
            return;
        }
        double speed = this.getDeltaMovement().length();
        if (speed > 0.1) {
            Level level = this.level();
            BlockPos resultPos = blockResult.getBlockPos();
            BlockState state = level.getBlockState(resultPos);
            SoundEvent event = ((BlockBehaviourInvoker)state.getBlock()).invokeGetSoundType(state).getStepSound();
            level.playSound(null, result.getLocation().x, result.getLocation().y, result.getLocation().z, event, SoundSource.AMBIENT, 1.0f, 1.0f);
        }
        this.bounce(blockResult.getDirection());
    }

    private void bounce(Direction direction) {
        switch (direction.getAxis()) {
            case X: {
                this.setDeltaMovement(this.getDeltaMovement().multiply(-0.15, 0.5, 0.5));
                break;
            }
            case Y: {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, -0.15, 0.5));
                if (!(this.getDeltaMovement().y() < this.getGravity())) break;
                this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.0, 1.0));
                break;
            }
            case Z: {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, 0.5, -0.15));
            }
        }
    }

    public boolean isNoGravity() {
        return false;
    }
}

