/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.explosion;

import com.avp.common.gameplay.explosion.ExplosionBlockSamplerPredicate;
import com.avp.common.gameplay.explosion.ExplosionBuilder;
import com.avp.common.gameplay.explosion.ExplosionCallbacks;
import com.avp.common.gameplay.explosion.ExplosionConfig;
import com.avp.common.gameplay.explosion.ExplosionProcessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;

public class Explosion {
    private final ExplosionCallbacks callbacks;
    private final ExplosionConfig config;
    private final ExplosionProcessor explosionProcessor;
    private final ServerLevel level;
    private final ExplosionBlockSamplerPredicate samplerPredicate;

    public static ExplosionBuilder builder(ServerLevel level, Vec3 center) {
        return new ExplosionBuilder(level, center);
    }

    Explosion(ServerLevel level, ExplosionCallbacks callbacks, ExplosionConfig config, ExplosionBlockSamplerPredicate samplerPredicate) {
        this.callbacks = callbacks;
        this.config = config;
        this.explosionProcessor = new ExplosionProcessor(this);
        this.level = level;
        this.samplerPredicate = samplerPredicate;
    }

    public void explode() {
        this.callbacks.onExplosionStart();
        this.explosionProcessor.process();
    }

    public ExplosionCallbacks callbacks() {
        return this.callbacks;
    }

    public ExplosionConfig config() {
        return this.config;
    }

    public ServerLevel level() {
        return this.level;
    }

    public ExplosionBlockSamplerPredicate samplerPredicate() {
        return this.samplerPredicate;
    }
}

