/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.explosion;

import com.avp.common.gameplay.explosion.Explosion;
import com.avp.common.util.ExplosionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

@FunctionalInterface
public interface ExplosionBlockSamplerPredicate {
    public static final ExplosionBlockSamplerPredicate DEFAULT = (explosion, pos) -> {
        int z;
        int y;
        ServerLevel level = explosion.level();
        BlockState state = level.getBlockState(pos);
        BlockPos centerPos = explosion.config().centerBlockPosition();
        if (state.is(Blocks.AIR) || state.is(Blocks.BEDROCK)) {
            return false;
        }
        int x = pos.getX() - centerPos.getX();
        return ExplosionUtil.getNormalizedDistance(explosion, x, y = pos.getY() - centerPos.getY(), z = pos.getZ() - centerPos.getZ()) <= 1.0;
    };

    public boolean test(Explosion var1, BlockPos var2);
}

