/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.explosion;

import com.avp.common.gameplay.explosion.Explosion;
import com.avp.common.gameplay.explosion.ExplosionBlockSampler;
import com.avp.common.gameplay.explosion.ExplosionBlockSamplerPredicate;
import com.avp.common.gameplay.explosion.ExplosionCallbacks;
import com.avp.common.gameplay.explosion.ExplosionConfig;
import com.lib.common.util.DirectionUtil;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;

public class ExplosionBuilder {
    private final ExplosionCallbacks.Builder callbacksBuilder;
    private final Vec3 center;
    private final ServerLevel level;
    private final Map<Direction, Integer> directionToRadiusMap;
    int blockSampleCountPerCycle;
    int cycleDelayInTicks;
    private ExplosionBlockSamplerPredicate samplerPredicate;

    ExplosionBuilder(ServerLevel level, Vec3 center) {
        this.level = level;
        this.callbacksBuilder = ExplosionCallbacks.builder();
        this.center = center;
        this.directionToRadiusMap = new EnumMap<Direction, Integer>(Direction.class);
        this.blockSampleCountPerCycle = Short.MAX_VALUE;
        this.cycleDelayInTicks = 1;
        this.samplerPredicate = ExplosionBlockSamplerPredicate.DEFAULT;
    }

    public ExplosionBuilder onBlockSample(ExplosionBlockSampler sampler) {
        this.callbacksBuilder.withOnBlockSampleCallback(sampler);
        return this;
    }

    public ExplosionBuilder onCycleFinish(Consumer<List<BlockPos>> callback) {
        this.callbacksBuilder.withOnCycleFinishCallback(callback);
        return this;
    }

    public ExplosionBuilder onCycleStart(Runnable callback) {
        this.callbacksBuilder.withOnCycleStartCallback(callback);
        return this;
    }

    public ExplosionBuilder onExplosionFinish(Runnable callback) {
        this.callbacksBuilder.withOnExplosionFinishCallback(callback);
        return this;
    }

    public ExplosionBuilder onExplosionStart(Runnable callback) {
        this.callbacksBuilder.withOnExplosionStartCallback(callback);
        return this;
    }

    public ExplosionBuilder withBlockSampleCountPerCycle(int blockSampleCountPerCycle) {
        this.blockSampleCountPerCycle = blockSampleCountPerCycle;
        return this;
    }

    public ExplosionBuilder withCycleDelayInTicks(int cycleDelayInTicks) {
        this.cycleDelayInTicks = cycleDelayInTicks;
        return this;
    }

    public ExplosionBuilder withRadius(int radius) {
        for (Direction direction : DirectionUtil.VALUES) {
            this.withRadius(direction, radius);
        }
        return this;
    }

    public ExplosionBuilder withRadius(Direction.Plane plane, int radius) {
        plane.stream().forEach(direction -> this.withRadius((Direction)direction, radius));
        return this;
    }

    public ExplosionBuilder withRadius(Direction.Axis axis, int radius) {
        Direction direction = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        this.withRadius(direction, radius);
        this.withRadius(direction.getOpposite(), radius);
        return this;
    }

    public ExplosionBuilder withRadius(Direction direction, int radius) {
        this.directionToRadiusMap.put(direction, radius);
        return this;
    }

    public ExplosionBuilder withSamplerPredicate(ExplosionBlockSamplerPredicate samplerPredicate) {
        this.samplerPredicate = samplerPredicate;
        return this;
    }

    public Explosion build() {
        ExplosionCallbacks callbacks = this.callbacksBuilder.build();
        BlockPos centerBlockPosition = new BlockPos((int)this.center.x, (int)this.center.y, (int)this.center.z);
        ExplosionConfig config = new ExplosionConfig(this.blockSampleCountPerCycle, this.center, centerBlockPosition, this.cycleDelayInTicks, this.directionToRadiusMap);
        return new Explosion(this.level, callbacks, config, this.samplerPredicate);
    }
}

