/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.explosion;

import com.avp.common.gameplay.explosion.Explosion;
import com.avp.common.gameplay.explosion.ExplosionBlockSampler;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.Nullable;

public class ExplosionCallbacks {
    @Nullable
    private ExplosionBlockSampler onBlockSampleCallback;
    @Nullable
    private Consumer<List<BlockPos>> onCycleFinishCallback;
    @Nullable
    private Runnable onCycleStartCallback;
    @Nullable
    private Runnable onExplosionFinishCallback;
    @Nullable
    private Runnable onExplosionStartCallback;

    public static Builder builder() {
        return new Builder();
    }

    private ExplosionCallbacks() {
    }

    public void onBlockSample(Explosion explosion, BlockPos pos) {
        if (this.onBlockSampleCallback != null) {
            this.onBlockSampleCallback.sample(explosion, pos);
        }
    }

    public void onCycleFinish(List<BlockPos> sampledBlockPositions) {
        if (this.onCycleFinishCallback != null) {
            this.onCycleFinishCallback.accept(sampledBlockPositions);
        }
    }

    public void onCycleStart() {
        if (this.onCycleStartCallback != null) {
            this.onCycleStartCallback.run();
        }
    }

    public void onExplosionFinish() {
        if (this.onExplosionFinishCallback != null) {
            this.onExplosionFinishCallback.run();
        }
    }

    public void onExplosionStart() {
        if (this.onExplosionStartCallback != null) {
            this.onExplosionStartCallback.run();
        }
    }

    public static class Builder {
        private final ExplosionCallbacks callbacks = new ExplosionCallbacks();

        private Builder() {
        }

        public void withOnBlockSampleCallback(ExplosionBlockSampler sampler) {
            this.callbacks.onBlockSampleCallback = sampler;
        }

        public void withOnCycleFinishCallback(Consumer<List<BlockPos>> callback) {
            this.callbacks.onCycleFinishCallback = callback;
        }

        public void withOnCycleStartCallback(Runnable callback) {
            this.callbacks.onCycleStartCallback = callback;
        }

        public void withOnExplosionFinishCallback(Runnable callback) {
            this.callbacks.onExplosionFinishCallback = callback;
        }

        public void withOnExplosionStartCallback(Runnable callback) {
            this.callbacks.onExplosionStartCallback = callback;
        }

        public ExplosionCallbacks build() {
            return this.callbacks;
        }
    }
}

