/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.explosion;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;

public record ExplosionConfig(int blockSampleCountPerCycle, Vec3 centerPosition, BlockPos centerBlockPosition, int cycleDelayInTicks, Map<Direction, Integer> directionToRadiusMap) {
    public int radius(Direction direction) {
        return this.directionToRadiusMap.get(direction);
    }

    public int largestRadius(Direction.Axis axis) {
        Direction leftDirection = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        int left = this.radius(leftDirection);
        int right = this.radius(leftDirection.getOpposite());
        return Math.max(left, right);
    }

    public int largestRadius(Direction.Plane plane) {
        return this.directionToRadiusMap.entrySet().stream().filter(entry -> plane.test((Direction)entry.getKey())).map(Map.Entry::getValue).max(Integer::compareTo).orElseThrow();
    }

    public int largestRadius() {
        return this.directionToRadiusMap.values().stream().max(Integer::compareTo).orElseThrow();
    }
}

