/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.registry.init.item;

import com.alien.common.gameplay.item.RoyalJellyBlockItem;
import com.avp.common.registry.AVPDeferredHolder;
import com.avp.common.registry.init.block.AVPBlocks;
import com.avp.common.registry.init.block.CoreBlocks;
import com.avp.common.registry.init.item.AVPItems;
import com.avp.service.Services;
import com.human.common.gameplay.block_item.AmmoChestBlockItem;
import com.human.common.gameplay.block_item.LeadChestBlockItem;
import com.human.common.gameplay.block_item.SentryTurretBlockItem;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class AVPBlockItems {
    public static final AVPDeferredHolder<BlockItem> ALUMINUM_BLOCK = AVPBlockItems.register("aluminum_block", CoreBlocks.ALUMINUM_BLOCK);
    public static final AVPDeferredHolder<BlockItem> AMMO_CHEST = AVPBlockItems.registerWithSupplier("ammo_chest", AmmoChestBlockItem::new);
    public static final AVPDeferredHolder<BlockItem> ASH_BLOCK = AVPBlockItems.register("ash_block", CoreBlocks.ASH_BLOCK);
    public static final AVPDeferredHolder<BlockItem> AUTUNITE_BLOCK = AVPBlockItems.register("autunite_block", CoreBlocks.AUTUNITE_BLOCK);
    public static final AVPDeferredHolder<BlockItem> AUTUNITE_ORE = AVPBlockItems.register("autunite_ore", CoreBlocks.AUTUNITE_ORE);
    public static final AVPDeferredHolder<BlockItem> BATTERY = AVPBlockItems.register("battery", AVPBlocks.BATTERY);
    public static final AVPDeferredHolder<BlockItem> BAUXITE_ORE = AVPBlockItems.register("bauxite_ore", CoreBlocks.BAUXITE_ORE);
    public static final AVPDeferredHolder<BlockItem> BLUEPRINT_BLOCK = AVPBlockItems.register("blueprint_block", AVPBlocks.BLUEPRINT_BLOCK);
    public static final AVPDeferredHolder<BlockItem> CABLE = AVPBlockItems.register("cable", AVPBlocks.CABLE);
    public static final AVPDeferredHolder<BlockItem> BRASS_BLOCK = AVPBlockItems.register("brass_block", CoreBlocks.BRASS_BLOCK);
    public static final AVPDeferredHolder<BlockItem> DEEPSLATE_TITANIUM_ORE = AVPBlockItems.register("deepslate_titanium_ore", CoreBlocks.DEEPSLATE_TITANIUM_ORE);
    public static final AVPDeferredHolder<BlockItem> DEEPSLATE_ZINC_ORE = AVPBlockItems.register("deepslate_zinc_ore", CoreBlocks.DEEPSLATE_ZINC_ORE);
    public static final AVPDeferredHolder<BlockItem> DESK_TERMINAL_BLOCK = AVPBlockItems.register("desk_terminal", AVPBlocks.DESK_TERMINAL_BLOCK);
    public static final AVPDeferredHolder<BlockItem> GALENA_ORE = AVPBlockItems.register("galena_ore", CoreBlocks.GALENA_ORE);
    public static final AVPDeferredHolder<BlockItem> INDUSTRIAL_FURNACE_BLOCK = AVPBlockItems.register("industrial_furnace_block", AVPBlocks.INDUSTRIAL_FURNACE);
    public static final AVPDeferredHolder<BlockItem> INFINITE_POWER_GENERATOR = AVPBlockItems.register("infinite_power_generator", AVPBlocks.INFINITE_POWER_GENERATOR);
    public static final AVPDeferredHolder<BlockItem> LEAD_BLOCK = AVPBlockItems.register("lead_block", CoreBlocks.LEAD_BLOCK);
    public static final AVPDeferredHolder<BlockItem> LEAD_CHEST = AVPBlockItems.registerWithSupplier("lead_chest", LeadChestBlockItem::new);
    public static final AVPDeferredHolder<BlockItem> LITHIUM_BLOCK = AVPBlockItems.register("lithium_block", CoreBlocks.LITHIUM_BLOCK);
    public static final AVPDeferredHolder<BlockItem> LITHIUM_ORE = AVPBlockItems.register("lithium_ore", CoreBlocks.LITHIUM_ORE);
    public static final AVPDeferredHolder<BlockItem> MONAZITE_ORE = AVPBlockItems.register("monazite_ore", CoreBlocks.MONAZITE_ORE);
    public static final AVPDeferredHolder<BlockItem> NUKE_BLOCK = AVPBlockItems.register("nuke", AVPBlocks.NUKE_BLOCK);
    public static final AVPDeferredHolder<BlockItem> RAW_BAUXITE_BLOCK = AVPBlockItems.register("raw_bauxite_block", CoreBlocks.RAW_BAUXITE_BLOCK);
    public static final AVPDeferredHolder<BlockItem> RAW_GALENA_BLOCK = AVPBlockItems.register("raw_galena_block", CoreBlocks.RAW_GALENA_BLOCK);
    public static final AVPDeferredHolder<BlockItem> RAW_MONAZITE_BLOCK = AVPBlockItems.register("raw_monazite_block", CoreBlocks.RAW_MONAZITE_BLOCK);
    public static final AVPDeferredHolder<BlockItem> RAW_TITANIUM_BLOCK = AVPBlockItems.register("raw_titanium_block", CoreBlocks.RAW_TITANIUM_BLOCK);
    public static final AVPDeferredHolder<BlockItem> RAW_ZINC_BLOCK = AVPBlockItems.register("raw_zinc_block", CoreBlocks.RAW_ZINC_BLOCK);
    public static final AVPDeferredHolder<BlockItem> RAZOR_WIRE = AVPBlockItems.register("razor_wire", AVPBlocks.RAZOR_WIRE);
    public static final AVPDeferredHolder<BlockItem> REDSTONE_GENERATOR = AVPBlockItems.register("redstone_generator", AVPBlocks.REDSTONE_GENERATOR);
    public static final AVPDeferredHolder<BlockItem> RESONATOR_BLOCK = AVPBlockItems.register("resonator", AVPBlocks.RESONATOR_BLOCK);
    public static final AVPDeferredHolder<BlockItem> ROYAL_JELLY_BLOCK = AVPBlockItems.registerWithSupplier("royal_jelly_block", RoyalJellyBlockItem::new);
    public static final AVPDeferredHolder<BlockItem> SENTRY_TURRET = AVPBlockItems.registerWithSupplier("sentry_turret", SentryTurretBlockItem::new);
    public static final AVPDeferredHolder<BlockItem> SILICA_GRAVEL = AVPBlockItems.register("silica_gravel", CoreBlocks.SILICA_GRAVEL);
    public static final AVPDeferredHolder<BlockItem> SILICON_BLOCK = AVPBlockItems.register("raw_silica_block", CoreBlocks.SILICON_BLOCK);
    public static final AVPDeferredHolder<BlockItem> SOLAR_PANEL = AVPBlockItems.register("solar_panel", AVPBlocks.SOLAR_PANEL);
    public static final AVPDeferredHolder<BlockItem> THERMAL_GENERATOR = AVPBlockItems.register("thermal_generator", AVPBlocks.THERMAL_GENERATOR);
    public static final AVPDeferredHolder<BlockItem> TRINITITE_BLOCK = AVPBlockItems.register("trinitite_block", CoreBlocks.TRINITITE_BLOCK);
    public static final AVPDeferredHolder<BlockItem> URANIUM_BLOCK = AVPBlockItems.register("uranium_block", CoreBlocks.URANIUM_BLOCK);
    public static final AVPDeferredHolder<BlockItem> WIND_TURBINE = AVPBlockItems.register("wind_turbine", AVPBlocks.WIND_TURBINE);
    public static final AVPDeferredHolder<BlockItem> ZINC_BLOCK = AVPBlockItems.register("zinc_block", CoreBlocks.ZINC_BLOCK);
    public static final AVPDeferredHolder<BlockItem> ZINC_ORE = AVPBlockItems.register("zinc_ore", CoreBlocks.ZINC_ORE);
    public static final Map<DyeColor, Supplier<BlockItem>> DYE_COLOR_TO_CONCRETE_SLAB = Collections.unmodifiableMap(Arrays.stream(DyeColor.values()).collect(Collectors.toMap(Function.identity(), dyeColor -> AVPBlockItems.register(dyeColor.getName() + "_concrete_slab", (Supplier<? extends Block>)AVPBlocks.DYE_COLOR_TO_CONCRETE_SLAB.get(dyeColor)))));
    public static final Map<DyeColor, Supplier<BlockItem>> DYE_COLOR_TO_CONCRETE_STAIRS = Collections.unmodifiableMap(Arrays.stream(DyeColor.values()).collect(Collectors.toMap(Function.identity(), dyeColor -> AVPBlockItems.register(dyeColor.getName() + "_concrete_stairs", (Supplier<? extends Block>)AVPBlocks.DYE_COLOR_TO_CONCRETE_STAIRS.get(dyeColor)))));

    public static AVPDeferredHolder<BlockItem> register(String id, Supplier<? extends Block> blockSupplier) {
        return AVPBlockItems.register(id, blockSupplier, new Item.Properties());
    }

    public static AVPDeferredHolder<BlockItem> register(String id, Supplier<? extends Block> blockSupplier, Item.Properties properties) {
        return AVPBlockItems.registerWithSupplier(id, () -> new BlockItem((Block)blockSupplier.get(), properties));
    }

    public static AVPDeferredHolder<BlockItem> registerWithSupplier(String id, Supplier<BlockItem> blockItemSupplier) {
        return AVPItems.register(id, blockItemSupplier);
    }

    public static void initialize() {
        Services.REGISTRY.registerAzureLibIdentity(RESONATOR_BLOCK);
        Services.REGISTRY.registerAzureLibIdentity(SENTRY_TURRET);
    }
}

