/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.util;

import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;

public class AVPEntityTransitionUtil {
    public static final Set<String> DEFAULT_NBT_KEY_BLACKLIST = Set.of("id", "UUID", "Pos", "Motion", "Rotation", "Health", "attributes");

    public static <T extends Entity> EntityTransitionResult transitionInto(Entity oldEntity, EntityType<T> newEntityType) {
        return AVPEntityTransitionUtil.transitionInto(oldEntity, newEntityType, DEFAULT_NBT_KEY_BLACKLIST);
    }

    public static <T extends Entity> EntityTransitionResult transitionInto(Entity oldEntity, EntityType<T> newEntityType, Set<String> blacklistedKeys) {
        boolean canFitAtPosition;
        Level level = oldEntity.level();
        if (level.isClientSide) {
            return EntityTransitionResult.ClientSide.INSTANCE;
        }
        Entity newEntity = newEntityType.create(level);
        if (newEntity == null) {
            return EntityTransitionResult.EntityCreation.INSTANCE;
        }
        newEntity.setPos(oldEntity.position());
        boolean bl = canFitAtPosition = level.noBlockCollision(newEntity, newEntity.getBoundingBox()) && !level.containsAnyLiquid(newEntity.getBoundingBox());
        if (!canFitAtPosition) {
            return EntityTransitionResult.Obstructed.INSTANCE;
        }
        AVPEntityTransitionUtil.migrateEntityData(oldEntity, newEntity, blacklistedKeys);
        level.addFreshEntity(newEntity);
        oldEntity.discard();
        return new EntityTransitionResult.Success<Entity>(newEntity);
    }

    public static void migrateEntityData(Entity oldEntity, Entity newEntity) {
        AVPEntityTransitionUtil.migrateEntityData(oldEntity, newEntity, DEFAULT_NBT_KEY_BLACKLIST);
    }

    public static void migrateEntityData(Entity oldEntity, Entity newEntity, Set<String> blacklistedKeys) {
        CompoundTag oldEntityData = new CompoundTag();
        oldEntity.save(oldEntityData);
        blacklistedKeys.forEach(arg_0 -> ((CompoundTag)oldEntityData).remove(arg_0));
        newEntity.load(oldEntityData);
        newEntity.moveTo(oldEntity.position(), oldEntity.getYRot(), oldEntity.getXRot());
        newEntity.setYRot(oldEntity.getYRot());
        newEntity.setXRot(oldEntity.getXRot());
        newEntity.setDeltaMovement(oldEntity.getDeltaMovement());
        if (oldEntity instanceof LivingEntity) {
            LivingEntity oldLivingEntity = (LivingEntity)oldEntity;
            if (newEntity instanceof LivingEntity) {
                LivingEntity newLivingEntity = (LivingEntity)newEntity;
                newLivingEntity.yBodyRot = oldLivingEntity.yBodyRot;
                newLivingEntity.yHeadRot = oldLivingEntity.yHeadRot;
                for (MobEffectInstance effect : oldLivingEntity.getActiveEffects()) {
                    newLivingEntity.addEffect(new MobEffectInstance(effect));
                }
            }
        }
        if (oldEntity instanceof Mob) {
            Mob oldMobEntity = (Mob)oldEntity;
            if (newEntity instanceof Mob) {
                Mob newMobEntity = (Mob)newEntity;
                if (oldMobEntity.isPersistenceRequired()) {
                    newMobEntity.setPersistenceRequired();
                }
            }
        }
    }

    public static sealed interface EntityTransitionResult {

        public record Success<T extends Entity>(T newEntity) implements EntityTransitionResult
        {
        }

        public static enum Obstructed implements EntityTransitionResult
        {
            INSTANCE;

        }

        public static enum EntityCreation implements EntityTransitionResult
        {
            INSTANCE;

        }

        public static enum ClientSide implements EntityTransitionResult
        {
            INSTANCE;

        }
    }
}

