/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.util;

import com.avp.common.registry.init.item.AVPItems;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.avp.common.util.AVPPredicates;
import com.predator.common.gameplay.entity.projectile.ShurikenProjectile;
import com.predator.common.gameplay.entity.projectile.SmartDiscProjectile;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.Vec3;

public class ItemGoalUtil {
    public static void shootShuriken(PathfinderMob entity) {
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.TRIDENT_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (entity.level().getRandom().nextFloat() * 0.4f + 0.8f));
        if (!entity.level().isClientSide && entity.getTarget() != null) {
            double targetX = entity.getTarget().getX();
            double targetY = entity.getTarget().getY(1.0);
            double targetZ = entity.getTarget().getZ();
            double sourceX = entity.getX();
            double sourceY = entity.getY(0.5);
            double sourceZ = entity.getZ();
            double directionX = targetX - sourceX;
            double directionY = targetY - sourceY;
            double directionZ = targetZ - sourceZ;
            double length = Math.sqrt(directionX * directionX + directionY * directionY + directionZ * directionZ);
            ShurikenProjectile shurikenItemEntity = new ShurikenProjectile(entity.level(), (LivingEntity)entity);
            shurikenItemEntity.setOwner((Entity)entity);
            shurikenItemEntity.setPos(sourceX, sourceY, sourceZ);
            float velocity = 1.5f;
            shurikenItemEntity.setDeltaMovement((directionX /= length) * (double)velocity, (directionY /= length) * (double)velocity, (directionZ /= length) * (double)velocity);
            entity.level().addFreshEntity((Entity)shurikenItemEntity);
        }
    }

    public static void shootSmartDisc(PathfinderMob entity) {
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.TRIDENT_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (entity.level().getRandom().nextFloat() * 0.4f + 0.8f));
        if (!entity.level().isClientSide && entity.getTarget() != null) {
            double targetX = entity.getTarget().getX();
            double targetY = entity.getTarget().getY(1.0);
            double targetZ = entity.getTarget().getZ();
            double sourceX = entity.getX();
            double sourceY = entity.getY(0.5);
            double sourceZ = entity.getZ();
            double directionX = targetX - sourceX;
            double directionY = targetY - sourceY;
            double directionZ = targetZ - sourceZ;
            double length = Math.sqrt(directionX * directionX + directionY * directionY + directionZ * directionZ);
            SmartDiscProjectile smartDiscItemEntity = new SmartDiscProjectile(entity.level(), (LivingEntity)entity);
            smartDiscItemEntity.setOwner((Entity)entity);
            smartDiscItemEntity.setPos(sourceX, sourceY, sourceZ);
            float velocity = 3.5f;
            smartDiscItemEntity.setDeltaMovement((directionX /= length) * (double)velocity, (directionY /= length) * (double)velocity, (directionZ /= length) * (double)velocity);
            entity.level().addFreshEntity((Entity)smartDiscItemEntity);
        }
    }

    public static void trackToLivingEntity(Projectile projectile, Double bulletSpeed, Boolean highLightMob) {
        List livingEntities = projectile.level().getEntitiesOfClass(LivingEntity.class, projectile.getBoundingBox().inflate(5.0), livingEntity -> !livingEntity.getType().is(AVPEntityTypeTags.PREDATORS) && !AVPPredicates.IS_IMMORTAL.test((LivingEntity)livingEntity) && livingEntity != projectile.getOwner());
        if (!livingEntities.isEmpty()) {
            LivingEntity first = (LivingEntity)livingEntities.getFirst();
            if (Boolean.TRUE.equals(highLightMob)) {
                first.setGlowingTag(true);
            }
            Vec3 entityPos = new Vec3(first.getX(), first.getY() + (double)first.getEyeHeight(), first.getZ());
            Vec3 directionToTarget = entityPos.subtract(projectile.position()).normalize();
            Vec3 newVelocity = directionToTarget.scale(bulletSpeed.doubleValue());
            projectile.setDeltaMovement(newVelocity);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void trackToOwnerEntity(Projectile projectile) {
        if (projectile.getOwner() == null) {
            return;
        }
        Vec3 vec3 = projectile.getOwner().getEyePosition().subtract(projectile.position());
        projectile.setPosRaw(projectile.getX(), projectile.getY() + vec3.y * 0.015, projectile.getZ());
        if (projectile.level().isClientSide) {
            projectile.yOld = projectile.getY();
        }
        projectile.setDeltaMovement(projectile.getDeltaMovement().scale(0.95).add(vec3.normalize().scale(0.5)));
        Entity entity = projectile.getOwner();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (projectile.getBoundingBox().intersects(projectile.getOwner().getBoundingBox())) {
                if (!AVPPredicates.IS_IMMORTAL.test((LivingEntity)player)) {
                    player.getInventory().add(AVPItems.SMART_DISC.get().getDefaultInstance());
                }
                projectile.kill();
                return;
            }
        }
        if (!projectile.getBoundingBox().intersects(projectile.getOwner().getBoundingBox())) return;
        projectile.kill();
    }
}

