/*
 * Decompiled with CFR 0.152.
 */
package com.avp.mixin;

import com.lib.common.gameplay.entity.manager.GeneContainer;
import com.lib.common.model.GeneCarrier;
import com.lib.common.model.GeneDecayLevelType;
import com.lib.common.util.EmbryoUtil;
import com.lib.common.util.GeneIntegrityUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Animal.class})
public abstract class MixinAnimal_GeneCarrier
extends AgeableMob
implements GeneCarrier {
    public MixinAnimal_GeneCarrier(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract void finalizeSpawnChildFromBreeding(ServerLevel var1, Animal var2, @Nullable AgeableMob var3);

    @Inject(at={@At(value="HEAD")}, method={"spawnChildFromBreeding"})
    public void avp$spawnChildFromBreeding(ServerLevel level, Animal mate, CallbackInfo ci) {
        EmbryoUtil.birthEmbryos((LivingEntity)this, this.getOrCreateGeneManager().getGeneContainer(), parent -> this.avp$birthChild(level, mate), 0);
    }

    @Inject(at={@At(value="HEAD")}, method={"finalizeSpawnChildFromBreeding"})
    public void avp$finalizeSpawnChildFromBreeding(ServerLevel level, Animal mate, @Nullable AgeableMob baby, CallbackInfo ci) {
        if (baby == null) {
            return;
        }
        GeneCarrier geneCarrier = (GeneCarrier)baby;
        GeneContainer babyGeneContainer = geneCarrier.getOrCreateGeneManager().getGeneContainer();
        GeneContainer parentGeneContainer = this.getOrCreateGeneManager().getGeneContainer();
        GeneContainer otherParentGeneContainer = this.getOrCreateGeneManager().getGeneContainer();
        babyGeneContainer.getActiveGeneMap().putAll(parentGeneContainer.getActiveGeneMap().getBackingMap());
        babyGeneContainer.getActiveGeneMap().putAll(otherParentGeneContainer.getActiveGeneMap().getBackingMap());
        parentGeneContainer.getDormantGeneMap().getBackingMap().forEach(babyGeneContainer.getActiveGeneMap()::add);
        otherParentGeneContainer.getDormantGeneMap().getBackingMap().forEach(babyGeneContainer.getActiveGeneMap()::add);
        GeneDecayLevelType geneDecayLevel = GeneIntegrityUtil.getGeneDecayLevel(geneCarrier);
        switch (geneDecayLevel) {
            case FATAL: {
                baby.kill();
                break;
            }
            case VOLATILE: {
                double totalGeneIntegrity = Math.abs(GeneIntegrityUtil.getTotalGeneticIntegrity(geneCarrier));
                double chance = totalGeneIntegrity - Math.floor(totalGeneIntegrity);
                if (!(baby.getRandom().nextDouble() < chance)) break;
                baby.kill();
                break;
            }
        }
    }

    @Unique
    @Nullable
    public AgeableMob avp$birthChild(ServerLevel level, Animal mate) {
        AgeableMob ageablemob = this.getBreedOffspring(level, (AgeableMob)mate);
        if (ageablemob != null) {
            ageablemob.setBaby(true);
            ageablemob.moveTo(this.getX(), this.getY(), this.getZ(), 0.0f, 0.0f);
            this.finalizeSpawnChildFromBreeding(level, mate, ageablemob);
            level.addFreshEntityWithPassengers((Entity)ageablemob);
        }
        return ageablemob;
    }
}

