/*
 * Decompiled with CFR 0.152.
 */
package com.avp.neoforge.service;

import com.avp.client.input.keybind.util.KeyMappingUtil;
import com.avp.client.model.KeyInteractType;
import com.avp.service.ClientRegistryService;
import com.just.core.functional.function.Lazy;
import com.just.core.functional.tuple.Tuple2;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRenderer;
import mod.azure.azurelib.rewrite.render.item.AzItemRenderer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class NeoForgeClientRegistryService
implements ClientRegistryService {
    private final List<Tuple2<Supplier<AzArmorRenderer>, List<Supplier<Item>>>> armorRendererPairs = new ArrayList<Tuple2<Supplier<AzArmorRenderer>, List<Supplier<Item>>>>();
    private final List<Tuple2<Supplier<? extends BlockEntityType<? extends BlockEntity>>, BlockEntityRendererProvider<? extends BlockEntity>>> blockEntityRendererPairs = new ArrayList<Tuple2<Supplier<? extends BlockEntityType<? extends BlockEntity>>, BlockEntityRendererProvider<? extends BlockEntity>>>();
    private final List<Tuple2<Supplier<? extends Block>, RenderType>> blockRenderLayerPairs = new ArrayList<Tuple2<Supplier<? extends Block>, RenderType>>();
    private final List<Tuple2<Supplier<? extends EntityType<?>>, EntityRendererProvider<?>>> entityRendererPairs = new ArrayList();
    private final List<Tuple2<ItemColor, List<Supplier<Item>>>> itemColorPairs = new ArrayList<Tuple2<ItemColor, List<Supplier<Item>>>>();
    private final List<Tuple2<Supplier<? extends Item>, Function<String, Supplier<AzItemRenderer>>>> itemRendererPairs = new ArrayList<Tuple2<Supplier<? extends Item>, Function<String, Supplier<AzItemRenderer>>>>();
    private final List<Supplier<Tuple2<KeyMapping, Consumer<KeyInteractType>>>> keyMappingHandlerPairSuppliers = new ArrayList<Supplier<Tuple2<KeyMapping, Consumer<KeyInteractType>>>>();
    private final List<Tuple2<Supplier<? extends MenuType<?>>, MenuScreens.ScreenConstructor<?, ?>>> menuScreenConstructorPairs = new ArrayList();
    private final List<Tuple2<Supplier<? extends ParticleType<?>>, ParticleEngine.SpriteParticleRegistration<?>>> particleProviderFactoryPairs = new ArrayList();

    @Override
    public void registerArmorRenderer(Supplier<AzArmorRenderer> armorRendererSupplier, List<Supplier<Item>> itemSuppliers) {
        this.armorRendererPairs.add((Tuple2<Supplier<AzArmorRenderer>, List<Supplier<Item>>>)new Tuple2(armorRendererSupplier, itemSuppliers));
    }

    @Override
    public <T extends BlockEntity> void registerBlockEntityRenderer(Supplier<BlockEntityType<T>> blockEntityTypeSupplier, BlockEntityRendererProvider<T> renderProvider) {
        this.blockEntityRendererPairs.add((Tuple2<Supplier<? extends BlockEntityType<? extends BlockEntity>>, BlockEntityRendererProvider<? extends BlockEntity>>)new Tuple2(blockEntityTypeSupplier, renderProvider));
    }

    @Override
    public void registerBlockRenderLayer(Supplier<? extends Block> blockSupplier, RenderType renderType) {
        this.blockRenderLayerPairs.add((Tuple2<Supplier<? extends Block>, RenderType>)new Tuple2(blockSupplier, (Object)renderType));
    }

    @Override
    public <E extends Entity> void registerEntityRenderer(Supplier<EntityType<E>> entityTypeSupplier, EntityRendererProvider<E> entityRendererFactory) {
        this.entityRendererPairs.add(new Tuple2(entityTypeSupplier, entityRendererFactory));
    }

    @Override
    public void registerItemColor(ItemColor itemColor, List<Supplier<Item>> itemSuppliers) {
        this.itemColorPairs.add((Tuple2<ItemColor, List<Supplier<Item>>>)new Tuple2((Object)itemColor, itemSuppliers));
    }

    @Override
    public void registerItemRenderer(Supplier<? extends Item> itemSupplier, Function<String, Supplier<AzItemRenderer>> rendererFactory) {
        this.itemRendererPairs.add((Tuple2<Supplier<? extends Item>, Function<String, Supplier<AzItemRenderer>>>)new Tuple2(itemSupplier, rendererFactory));
    }

    @Override
    public Supplier<Tuple2<KeyMapping, Consumer<KeyInteractType>>> registerKeyMapping(String id, String category, int key, Consumer<KeyInteractType> keyInteractTypeConsumer) {
        Lazy supplier = Lazy.of(() -> new Tuple2((Object)KeyMappingUtil.createKeyMapping(id, category, key), (Object)keyInteractTypeConsumer));
        this.keyMappingHandlerPairSuppliers.add((Supplier<Tuple2<KeyMapping, Consumer<KeyInteractType>>>)supplier);
        return supplier;
    }

    @Override
    public <T extends AbstractContainerMenu, U extends Screen> void registerMenuScreen(Supplier<? extends MenuType<T>> menuTypeSupplier, MenuScreens.ScreenConstructor<T, U> screenConstructor) {
        this.menuScreenConstructorPairs.add(new Tuple2(menuTypeSupplier, screenConstructor));
    }

    @Override
    public <T extends ParticleOptions> void registerParticleProviderFactory(Supplier<? extends ParticleType<T>> particleTypeSupplier, ParticleEngine.SpriteParticleRegistration<T> spriteParticleRegistration) {
        this.particleProviderFactoryPairs.add(new Tuple2(particleTypeSupplier, spriteParticleRegistration));
    }

    public List<Tuple2<Supplier<AzArmorRenderer>, List<Supplier<Item>>>> getArmorRendererPairs() {
        return this.armorRendererPairs;
    }

    public List<Tuple2<Supplier<? extends BlockEntityType<? extends BlockEntity>>, BlockEntityRendererProvider<? extends BlockEntity>>> getBlockEntityRendererPairs() {
        return this.blockEntityRendererPairs;
    }

    public List<Tuple2<Supplier<? extends Block>, RenderType>> getBlockRenderLayerPairs() {
        return this.blockRenderLayerPairs;
    }

    public List<Tuple2<Supplier<? extends EntityType<?>>, EntityRendererProvider<?>>> getEntityRendererPairs() {
        return this.entityRendererPairs;
    }

    public List<Tuple2<ItemColor, List<Supplier<Item>>>> getItemColorPairs() {
        return this.itemColorPairs;
    }

    public List<Tuple2<Supplier<? extends Item>, Function<String, Supplier<AzItemRenderer>>>> getItemRendererPairs() {
        return this.itemRendererPairs;
    }

    public List<Supplier<Tuple2<KeyMapping, Consumer<KeyInteractType>>>> getKeyMappingHandlerPairSuppliers() {
        return this.keyMappingHandlerPairSuppliers;
    }

    public List<Tuple2<Supplier<? extends MenuType<?>>, MenuScreens.ScreenConstructor<?, ?>>> getMenuScreenConstructorPairs() {
        return this.menuScreenConstructorPairs;
    }

    public List<Tuple2<Supplier<? extends ParticleType<?>>, ParticleEngine.SpriteParticleRegistration<?>>> getParticleProviderFactoryPairs() {
        return this.particleProviderFactoryPairs;
    }
}

