/*
 * Decompiled with CFR 0.152.
 */
package com.avp.service;

import com.avp.client.model.KeyInteractType;
import com.avp.client.render.item.SimpleItemRenderer;
import com.just.core.functional.tuple.Tuple2;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRenderer;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererRegistry;
import mod.azure.azurelib.rewrite.render.item.AzItemRenderer;
import mod.azure.azurelib.rewrite.render.item.AzItemRendererRegistry;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public interface ClientRegistryService {
    public static final Function<String, Supplier<AzItemRenderer>> ITEM_RENDERER_SUPPLIER_FACTORY = name -> () -> new SimpleItemRenderer((String)name);

    public void registerArmorRenderer(Supplier<AzArmorRenderer> var1, List<Supplier<Item>> var2);

    default public void registerArmorRendererImmediately(Supplier<AzArmorRenderer> armorRendererSupplier, List<Supplier<Item>> itemSuppliers) {
        itemSuppliers.forEach(itemSupplier -> AzArmorRendererRegistry.register((Supplier)armorRendererSupplier, (Item)((Item)itemSupplier.get()), (Item[])new Item[0]));
    }

    public <T extends BlockEntity> void registerBlockEntityRenderer(Supplier<BlockEntityType<T>> var1, BlockEntityRendererProvider<T> var2);

    public void registerBlockRenderLayer(Supplier<? extends Block> var1, RenderType var2);

    public <E extends Entity> void registerEntityRenderer(Supplier<EntityType<E>> var1, EntityRendererProvider<E> var2);

    public void registerItemColor(ItemColor var1, List<Supplier<Item>> var2);

    default public void registerItemRenderer(Supplier<? extends Item> itemSupplier) {
        this.registerItemRenderer(itemSupplier, ITEM_RENDERER_SUPPLIER_FACTORY);
    }

    public void registerItemRenderer(Supplier<? extends Item> var1, Function<String, Supplier<AzItemRenderer>> var2);

    default public void registerItemRendererImmediately(Item item, Function<String, Supplier<AzItemRenderer>> rendererFactory) {
        String path = BuiltInRegistries.ITEM.getKey((Object)item).getPath();
        Supplier<AzItemRenderer> itemRendererSupplier = rendererFactory.apply(path);
        AzItemRendererRegistry.register(itemRendererSupplier, (Item)item, (Item[])new Item[0]);
    }

    public Supplier<Tuple2<KeyMapping, Consumer<KeyInteractType>>> registerKeyMapping(String var1, String var2, int var3, Consumer<KeyInteractType> var4);

    public <T extends AbstractContainerMenu, U extends Screen> void registerMenuScreen(Supplier<? extends MenuType<T>> var1, MenuScreens.ScreenConstructor<T, U> var2);

    public <T extends ParticleOptions> void registerParticleProviderFactory(Supplier<? extends ParticleType<T>> var1, ParticleEngine.SpriteParticleRegistration<T> var2);
}

