/*
 * Decompiled with CFR 0.152.
 */
package com.human.client.render.entity;

import com.avp.AVPResources;
import com.human.client.animation.entity.MushroomCloudAnimator;
import com.human.common.gameplay.entity.nuke.MushroomCloudEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererConfig;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class MushroomCloudRenderer
extends AzEntityRenderer<MushroomCloudEntity> {
    private static final String NAME = "mushroom_cloud";
    private static final ResourceLocation MODEL = AVPResources.entityGeoModelLocation("mushroom_cloud");
    private static final ResourceLocation TEXTURE = AVPResources.entityTextureLocation("mushroom_cloud");

    public MushroomCloudRenderer(EntityRendererProvider.Context context) {
        super(AzEntityRendererConfig.builder((ResourceLocation)MODEL, (ResourceLocation)TEXTURE).setAnimatorProvider(MushroomCloudAnimator::new).build(), context);
    }

    public void render(@NotNull MushroomCloudEntity entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        float progress = (float)entity.tickCount / 300.0f;
        progress = Math.min(progress, 1.0f);
        float scale = 1.0f + progress * 80.0f;
        poseStack.translate(0.0, -30.0, 0.0);
        poseStack.scale(scale, scale, scale);
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public boolean shouldRender(MushroomCloudEntity livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }
}

