/*
 * Decompiled with CFR 0.152.
 */
package com.human.client.render.entity;

import com.avp.AVPResources;
import com.human.common.gameplay.entity.projectile.Rocket;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererConfig;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class RocketRenderer
extends AzEntityRenderer<Rocket> {
    private static final String NAME = "rocket";
    private static final ResourceLocation MODEL = AVPResources.entityGeoModelLocation("rocket");
    private static final ResourceLocation TEXTURE = AVPResources.entityTextureLocation("rocket");

    public RocketRenderer(EntityRendererProvider.Context context) {
        super(AzEntityRendererConfig.builder((ResourceLocation)MODEL, (ResourceLocation)TEXTURE).build(), context);
    }

    public void render(@NotNull Rocket entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        poseStack.mulPose(Axis.YP.rotationDegrees(entity.getYRot()));
        poseStack.mulPose(Axis.XP.rotationDegrees(-entity.getXRot()));
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

