/*
 * Decompiled with CFR 0.152.
 */
package com.human.client.render.layer.human;

import com.human.common.gameplay.entity.living.human.AbstractHuman;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class HumanRenderLayerUtil {
    public static <T extends AbstractHuman> void applyColorWithInvisibility(AzRendererPipelineContext<T> context, @Nullable ResourceLocation textureLocation, int fallbackColor) {
        int color;
        double alphaValue;
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (textureLocation == null || localPlayer == null) {
            return;
        }
        AbstractHuman animatable = (AbstractHuman)context.animatable();
        AzRendererPipeline renderPipeline = context.rendererPipeline();
        boolean isInvisible = animatable.isInvisible();
        RenderType renderType = isInvisible ? RenderType.entityTranslucentCull((ResourceLocation)textureLocation) : RenderType.entityCutout((ResourceLocation)textureLocation);
        VertexConsumer vertexConsumer = context.multiBufferSource().getBuffer(renderType);
        double d = alphaValue = animatable.isInvisibleTo((Player)localPlayer) ? 0.0 : 0.38;
        if (isInvisible) {
            int alpha = (int)(alphaValue * 255.0) << 24;
            color = context.renderColor() & 0xFFFFFF | alpha;
        } else {
            color = fallbackColor;
        }
        context.setRenderColor(color);
        context.setVertexConsumer(vertexConsumer);
        renderPipeline.reRender(context);
    }

    private HumanRenderLayerUtil() {
        throw new UnsupportedOperationException();
    }
}

