/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.block.entity.power.impl;

import com.avp.common.registry.init.AVPBlockEntityTypes;
import com.human.common.gameplay.block.entity.power.PowerNodeBlockEntity;
import com.human.common.gameplay.power.PowerNode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class WindTurbineBlockEntity
extends PowerNodeBlockEntity
implements PowerNode.PowerProducer {
    public WindTurbineBlockEntity(BlockPos pos, BlockState state) {
        super(AVPBlockEntityTypes.WIND_TURBINE.get(), pos, state);
    }

    @Override
    public long getAvailablePower() {
        if (this.level == null || this.level.isClientSide) {
            return 0L;
        }
        BlockPos blockPos = this.getBlockPos();
        BlockPos abovePos = blockPos.above();
        if (!this.level.canSeeSky(abovePos)) {
            return 0L;
        }
        int baseOutput = blockPos.getY();
        double biomeFactor = this.computeBiomeFactor(this.level, blockPos);
        double weatherFactor = this.computeWeatherFactor(this.level);
        return (long)((double)baseOutput * biomeFactor * weatherFactor);
    }

    private double computeBiomeFactor(Level level, BlockPos blockPos) {
        Holder biome = level.getBiome(blockPos);
        if (biome.is(BiomeTags.IS_MOUNTAIN)) {
            return 2.0;
        }
        if (biome.is(BiomeTags.IS_HILL)) {
            return 1.75;
        }
        if (biome.is(BiomeTags.IS_OCEAN)) {
            return 1.5;
        }
        if (biome.is(BiomeTags.IS_BEACH)) {
            return 1.25;
        }
        return 1.0;
    }

    private double computeWeatherFactor(Level level) {
        if (level.isThundering()) {
            return 2.0;
        }
        if (level.isRaining()) {
            return 1.5;
        }
        return 1.0;
    }

    @Override
    public long extractPower(long maxAmount) {
        return maxAmount;
    }
}

