/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.entity.living.human;

import com.avp.AVPResources;
import com.human.common.gameplay.entity.living.human.AbstractHuman;
import com.just.core.functional.function.memo.Memo;
import com.just.core.functional.function.memo.Memo2;
import net.minecraft.resources.ResourceLocation;

public class HumanFeatureManager {
    private static final ResourceLocation EYES_TEXTURE_LOCATION = AVPResources.entityTextureLocation("human/generic/eyes/eyes");
    private final Memo<Integer, ResourceLocation> cachedBeardTexture = new Memo(beardVariantIndex -> AVPResources.entityTextureLocation("human/male/beard/beard_" + beardVariantIndex));
    private final Memo2<Boolean, Integer, ResourceLocation> cachedHairTexture = new Memo2((isMale, hairVariantIndex) -> AVPResources.entityTextureLocation("human/" + (isMale != false ? "male" : "female") + "/hair/hair_" + hairVariantIndex));
    private final Memo<Boolean, ResourceLocation> cachedOutfitTexture = new Memo(isMale -> AVPResources.entityTextureLocation("human/" + (isMale != false ? "male" : "female") + "/outfit/camo"));
    private final Memo<Boolean, ResourceLocation> cachedSkinTexture = new Memo(isMale -> AVPResources.entityTextureLocation("human/" + (isMale != false ? "male" : "female") + "/skin/skin"));
    private final AbstractHuman entity;

    public HumanFeatureManager(AbstractHuman entity) {
        this.entity = entity;
    }

    public ResourceLocation getEyesTexture() {
        return EYES_TEXTURE_LOCATION;
    }

    public ResourceLocation getBeardTextureOrNull() {
        return this.entity.getBeardVariantOrNull() == null ? null : (ResourceLocation)this.cachedBeardTexture.apply((Object)this.entity.getBeardVariantOrNull());
    }

    public ResourceLocation getHairTexture() {
        return (ResourceLocation)this.cachedHairTexture.apply((Object)this.entity.isMale.get(), (Object)this.entity.hairVariant.get());
    }

    public ResourceLocation getOutfitTexture() {
        return (ResourceLocation)this.cachedOutfitTexture.apply((Object)this.entity.isMale.get());
    }

    public ResourceLocation getSkinTexture() {
        return (ResourceLocation)this.cachedSkinTexture.apply((Object)this.entity.isMale.get());
    }
}

