/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.entity.living.human;

import com.avp.common.gameplay.ai.goal.WaterMoveControl;
import com.human.common.gameplay.entity.living.human.AbstractHuman;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.level.pathfinder.PathType;

public class HumanNavigationManager {
    private final GroundPathNavigation groundNavigation;
    private final MoveControl groundMoveControl;
    private final WaterBoundPathNavigation waterNavigation;
    private final WaterMoveControl waterMoveControl;

    public HumanNavigationManager(AbstractHuman humanMob, MoveControl moveControl) {
        this.groundMoveControl = moveControl;
        this.groundNavigation = new GroundPathNavigation((Mob)humanMob, humanMob.level());
        humanMob.setPathfindingMalus(PathType.WATER, 0.5f);
        this.waterMoveControl = new WaterMoveControl(humanMob);
        this.waterNavigation = new WaterBoundPathNavigation((Mob)humanMob, humanMob.level());
    }

    public void switchToGround(AbstractHuman humanMob, int priority, GoalSelector goalSelector) {
        humanMob.setMoveControl(this.groundMoveControl);
        humanMob.setNavigation((PathNavigation)this.groundNavigation);
    }

    public void switchToWater(AbstractHuman humanMob, int priority, GoalSelector goalSelector) {
        humanMob.setMoveControl(this.waterMoveControl);
        humanMob.setNavigation((PathNavigation)this.waterNavigation);
    }
}

