/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.entity.living.human.marine;

import com.avp.AVP;
import com.avp.common.model.inventory.AVPInventory;
import com.avp.common.model.inventory.AVPInventoryBearer;
import com.avp.common.registry.init.item.AVPArmorItems;
import com.avp.common.registry.init.item.AVPItems;
import com.human.common.gameplay.entity.living.human.AbstractHuman;
import com.human.common.gameplay.entity.living.human.marine.MarineAnimationDispatcher;
import com.human.common.gameplay.entity.living.human.marine.MarineInventory;
import com.human.common.gameplay.entity.living.human.marine.ai.MarineGOAP;
import com.human.common.registry.init.item.HumanGunItems;
import com.lib.common.gameplay.goap.GOAPUser;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Marine
extends AbstractHuman
implements AVPInventoryBearer,
GOAPUser<MarineGOAP> {
    private static final List<List<Supplier<Item>>> DEFAULT_ARMOR_SETS = List.of(List.of(AVPArmorItems.TACTICAL_HELMET, AVPArmorItems.TACTICAL_CHESTPLATE, AVPArmorItems.TACTICAL_LEGGINGS, AVPArmorItems.TACTICAL_BOOTS), List.of(AVPArmorItems.TACTICAL_CAMO_HELMET, AVPArmorItems.TACTICAL_CAMO_CHESTPLATE, AVPArmorItems.TACTICAL_CAMO_LEGGINGS, AVPArmorItems.TACTICAL_CAMO_BOOTS));
    private static final List<Supplier<Item>> USABLE_WEAPON_ITEM_SUPPLIERS = List.of(HumanGunItems.M88MOD4_COMBAT_PISTOL, HumanGunItems.M37_12_SHOTGUN, HumanGunItems.F903WE_RIFLE, HumanGunItems.M41A_PULSE_RIFLE, HumanGunItems.M4RA_BATTLE_RIFLE, () -> Items.IRON_AXE, () -> Items.IRON_SWORD);
    private static final List<EquipmentSlot> ARMOR_EQUIPMENT_SLOTS = List.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
    private final MarineAnimationDispatcher animationDispatcher = new MarineAnimationDispatcher(this);
    private final MarineInventory marineInventory = new MarineInventory(this);

    public static AttributeSupplier.Builder createMarineAttributes() {
        return Marine.applyFrom(AVP.config.statsConfigs.MARINE_STATS, Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE));
    }

    public Marine(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @Nullable
    public MarineGOAP createGOAP() {
        return new MarineGOAP(this);
    }

    @Override
    public void runAttackAnimations() {
        this.animationDispatcher.rightShoot();
    }

    protected void dropEquipment() {
        super.dropEquipment();
        this.marineInventory.dropItems();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.addInitialWeapon();
        this.marineInventory.addPersonalItem(new ItemStack((ItemLike)AVPItems.GRENADE.get()));
        this.addInitialArmor();
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    @Override
    public AVPInventory getInventory() {
        return this.marineInventory;
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.marineInventory.load(compoundTag);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        this.marineInventory.save(compoundTag);
    }

    private void addInitialArmor() {
        int randomArmorSetIndex = this.getRandom().nextInt(DEFAULT_ARMOR_SETS.size());
        ItemStack[] selectedArmor = (ItemStack[])DEFAULT_ARMOR_SETS.get(randomArmorSetIndex).stream().map(itemSupplier -> new ItemStack((ItemLike)itemSupplier.get())).toArray(ItemStack[]::new);
        for (int i = 0; i < ARMOR_EQUIPMENT_SLOTS.size(); ++i) {
            ItemStack itemStack = selectedArmor[i];
            ArmorItem armorItem = (ArmorItem)itemStack.getItem();
            this.setItemSlot(armorItem.getEquipmentSlot(), itemStack);
        }
    }

    private void addInitialWeapon() {
        this.marineInventory.addPersonalItem(new ItemStack((ItemLike)USABLE_WEAPON_ITEM_SUPPLIERS.get(this.random.nextInt(USABLE_WEAPON_ITEM_SUPPLIERS.size())).get()));
    }
}

