/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.entity.nuke;

import com.avp.AVP;
import com.avp.common.gameplay.explosion.Explosion;
import com.avp.common.registry.init.block.AVPBlocks;
import com.avp.common.util.ExplosionUtil;
import com.avp.server.ServerScheduler;
import com.human.common.registry.init.entity_type.HumanEntityTypes;
import java.time.Duration;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class PrimedNuke
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_FUSE_ID = SynchedEntityData.defineId(PrimedNuke.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<BlockState> DATA_BLOCK_STATE_ID = SynchedEntityData.defineId(PrimedNuke.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);

    public PrimedNuke(EntityType<? extends Entity> entityType, Level level) {
        super(entityType, level);
        this.noCulling = true;
    }

    public PrimedNuke(Level level) {
        this(HumanEntityTypes.NUKE.get(), level);
    }

    public void setFuse(int i) {
        this.entityData.set(DATA_FUSE_ID, (Object)i);
    }

    public int getFuse() {
        return (Integer)this.entityData.get(DATA_FUSE_ID);
    }

    public void setBlockState(BlockState blockState) {
        this.entityData.set(DATA_BLOCK_STATE_ID, (Object)blockState);
    }

    public BlockState getBlockState() {
        return (BlockState)this.entityData.get(DATA_BLOCK_STATE_ID);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_FUSE_ID, (Object)80);
        builder.define(DATA_BLOCK_STATE_ID, (Object)AVPBlocks.NUKE_BLOCK.get().defaultBlockState());
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        this.setFuse(compoundTag.getShort("fuse"));
        if (compoundTag.contains("block_state", 10)) {
            this.setBlockState(NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)compoundTag.getCompound("block_state")));
        }
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putShort("fuse", (short)this.getFuse());
        compoundTag.put("block_state", (Tag)NbtUtils.writeBlockState((BlockState)this.getBlockState()));
    }

    @NotNull
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    protected double getDefaultGravity() {
        return 0.04;
    }

    public void tick() {
        this.applyGravity();
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        Level level = this.level();
        int fuseValue = this.getFuse() - 1;
        this.setFuse(fuseValue);
        if (fuseValue <= 0 && !level.isClientSide && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.isNukeEnabled(serverLevel)) {
                ServerScheduler.schedule(() -> {
                    Explosion explosion = ExplosionUtil.createNuclearExplosion(serverLevel, this.blockPosition().getCenter(), 128, 5);
                    explosion.explode();
                }, Duration.ofSeconds(1L));
            }
            this.discard();
        } else if (this.tickCount % 20 == 0) {
            level.playSound(null, this.blockPosition(), SoundEvents.SMOKER_SMOKE, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public boolean isNukeEnabled(ServerLevel serverLevel) {
        if (serverLevel.getServer().isDedicatedServer()) {
            return AVP.config.blockConfigs.ENABLE_NUKE_BLOCK_MECHS;
        }
        return true;
    }
}

