/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.entity.projectile;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.model.alien.variant.AlienVariantType;
import com.avp.common.registry.key.AVPDamageTypeKeys;
import com.human.common.registry.init.entity_type.HumanEntityTypes;
import com.just.core.traversal.BFS;
import com.lib.common.util.DirectionUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class Flamethrow
extends ThrowableProjectile {
    private static final String IS_ENHANCED_ENHANCED = "IsEnhanced";
    private static final String TICK_COUNT_KEY = "TickCount";
    private boolean isEnhanced;

    public Flamethrow(EntityType<? extends Flamethrow> entityType, Level level) {
        super(entityType, level);
        this.isEnhanced = false;
    }

    public Flamethrow(Level level, LivingEntity livingEntity) {
        super(HumanEntityTypes.FLAMETHROW.get(), livingEntity, level);
    }

    public void tick() {
        super.tick();
        if (this.isInWater() || this.tickCount >= 300) {
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        Level level = this.level();
        if (level.isClientSide) {
            for (int i = 0; i < 2; ++i) {
                double x = this.getX() + this.random.nextDouble() * (double)this.getBbWidth() * 0.5;
                double y = this.getZ() + this.random.nextDouble() * (double)this.getBbWidth() * 0.5;
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, true, x, this.getY(0.8), y, 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, true, x, this.getY(0.8), y, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHit(@NotNull HitResult hitResult) {
        super.onHit(hitResult);
        Level level = this.level();
        if (!level.isClientSide) {
            HitResult hitResult2 = hitResult;
            Objects.requireNonNull(hitResult2);
            HitResult hitResult3 = hitResult2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntityHitResult.class, BlockHitResult.class}, (Object)hitResult3, n)) {
                case 0: {
                    EntityHitResult entityHitResult = (EntityHitResult)hitResult3;
                    this.firebomb(entityHitResult.getEntity().blockPosition());
                    break;
                }
                case 1: {
                    BlockHitResult blockHitResult = (BlockHitResult)hitResult3;
                    BlockPos hit = blockHitResult.getBlockPos();
                    Direction impactSide = blockHitResult.getDirection();
                    BlockPos airStart = hit.relative(impactSide);
                    this.firebomb(airStart);
                    break;
                }
            }
            this.discard();
        }
    }

    private void firebomb(BlockPos originPos) {
        int radius = this.isEnhanced ? 2 : 1;
        Registry registry = this.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE);
        DamageSource damageSource = new DamageSource((Holder)registry.getHolderOrThrow(AVPDamageTypeKeys.FLAMETHROW), this.getOwner());
        BlockPos bottomCorner = originPos.offset(-radius, -radius, -radius);
        BlockPos topCorner = originPos.offset(radius, radius, radius);
        List entitiesToHurt = this.level().getEntities((Entity)this, AABB.encapsulatingFullBlocks((BlockPos)bottomCorner, (BlockPos)topCorner));
        entitiesToHurt.forEach(entity -> {
            entity.hurt(damageSource, 1.0f);
            entity.igniteForTicks(200);
            entity.invulnerableTime = 0;
        });
        BFS.traverse((Object)originPos, pos -> Arrays.stream(DirectionUtil.VALUES).map(arg_0 -> ((BlockPos)pos).relative(arg_0)).filter(this::shouldPlaceFireAt).toList(), pos -> this.level().setBlockAndUpdate(pos, Blocks.FIRE.defaultBlockState()), pos -> originPos.distManhattan((Vec3i)pos) > radius + 1);
    }

    private boolean shouldPlaceFireAt(BlockPos pos) {
        BlockState state = this.level().getBlockState(pos);
        AlienVariantType alienVariantType = AlienVariantTypes.getForOrNull(state);
        if (alienVariantType == AlienVariantTypes.NETHER) {
            return false;
        }
        return state.canBeReplaced() && state.getFluidState().isEmpty();
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        this.isEnhanced = tag.getBoolean(IS_ENHANCED_ENHANCED);
        this.tickCount = tag.getShort(TICK_COUNT_KEY);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putBoolean(IS_ENHANCED_ENHANCED, this.isEnhanced);
        tag.putShort(TICK_COUNT_KEY, (short)this.tickCount);
    }

    public void setEnhanced(boolean enhanced) {
        this.isEnhanced = enhanced;
    }
}

