/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item.canister;

import com.avp.common.registry.init.item.AVPItems;
import com.human.common.gameplay.item.canister.CanisterItem;
import com.human.common.registry.init.HumanDataComponents;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MilkCanisterItem
extends Item {
    public MilkCanisterItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        int currentContentAmount = (Integer)stack.getOrDefault(HumanDataComponents.CANISTER_CAPACITY.get(), (Object)0);
        if (currentContentAmount == 0) {
            return;
        }
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.avp.capacity").append(currentContentAmount + "/8"));
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        boolean canDeplete;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, stack);
            serverPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (!level.isClientSide) {
            livingEntity.removeAllEffects();
        }
        boolean bl = canDeplete = (Integer)stack.getOrDefault(HumanDataComponents.CANISTER_CAPACITY.get(), (Object)0) > 1;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (canDeplete && !player.isCreative()) {
                return CanisterItem.updateCapacity((LivingEntity)player, stack, -1);
            }
            return ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)AVPItems.CANISTER.get()), (boolean)false);
        }
        if (canDeplete) {
            return CanisterItem.updateCapacity(livingEntity, stack, -1);
        }
        stack.consume(1, livingEntity);
        return stack;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return 32;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.DRINK;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)usedHand);
    }
}

