/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item.grenade;

import com.human.common.gameplay.entity.projectile.ThrownGrenade;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class GrenadeItem
extends Item {
    private final boolean isIncendiary;
    private final boolean isIrradiated;

    public GrenadeItem(boolean isIncendiary, boolean isIrradiated) {
        super(new Item.Properties().stacksTo(16));
        this.isIncendiary = isIncendiary;
        this.isIrradiated = isIrradiated;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand interactionHand) {
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EGG_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide) {
            ThrownGrenade thrownGrenade = new ThrownGrenade(level, (LivingEntity)player);
            thrownGrenade.setItem(itemInHand);
            if (this.isIrradiated) {
                thrownGrenade.setIrradiated(true);
            }
            if (this.isIncendiary) {
                thrownGrenade.setIncendiary(true);
            }
            thrownGrenade.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.0f, 1.0f);
            level.addFreshEntity((Entity)thrownGrenade);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            itemInHand.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemInHand, (boolean)level.isClientSide());
    }
}

