/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item.gun;

import com.human.common.gameplay.item.gun.FireModeConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record GunConfig(@Nullable Supplier<ItemLike> ammunitionItemSupplier, int durability, List<FireModeConfig> fireModeConfigs, int maximumAmmunition, int reloadAmount, int reloadTimeInTicks) {
    @NotNull
    public FireModeConfig getDefaultFireMode() {
        return this.fireModeConfigs.getFirst();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<FireModeConfig> fireModeConfigs = new ArrayList<FireModeConfig>();
        private Supplier<ItemLike> ammunitionItemSupplier;
        private int durability;
        private int maximumAmmunition;
        private int reloadAmount = 1;
        private int reloadTimeInTicks;

        private Builder() {
        }

        public Builder withAmmunitionItemSupplier(Supplier<ItemLike> ammunitionItemSupplier) {
            this.ammunitionItemSupplier = ammunitionItemSupplier;
            return this;
        }

        public Builder withDurability(int durability) {
            this.durability = durability;
            return this;
        }

        public Builder withFireMode(FireModeConfig fireModeConfig) {
            this.fireModeConfigs.add(fireModeConfig);
            return this;
        }

        public Builder withMaximumAmmunition(int defaultMaxAmmunition) {
            this.maximumAmmunition = defaultMaxAmmunition;
            return this;
        }

        public Builder withReloadTimeInTicks(int reloadTimeInTicks) {
            this.reloadTimeInTicks = reloadTimeInTicks;
            return this;
        }

        public Builder withReloadAmount(int reloadAmount) {
            this.reloadAmount = reloadAmount;
            return this;
        }

        public GunConfig build() {
            if (this.fireModeConfigs.isEmpty()) {
                throw new IllegalStateException("At least 1 fire mode for guns is required.");
            }
            return new GunConfig(this.ammunitionItemSupplier, this.durability, Collections.unmodifiableList(this.fireModeConfigs), this.maximumAmmunition, this.reloadAmount, this.reloadTimeInTicks);
        }
    }
}

