/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item.gun;

import com.avp.common.registry.init.item.AVPBlockItems;
import com.avp.common.util.AVPPredicates;
import com.avp.server.ServerScheduler;
import com.human.common.gameplay.item.GunItem;
import com.human.common.gameplay.item.gun.FireModeConfig;
import com.human.common.gameplay.item.gun.GunConfig;
import com.human.common.gameplay.item.gun.GunData;
import com.human.common.registry.init.HumanDataComponents;
import com.lib.common.gameplay.util.EnchantmentUtil;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class GunReloading {
    public static void reload(Player player) {
        int ammunitionToRestore;
        ItemConsumptionResult.Full result;
        if (player == null) {
            return;
        }
        Level level = player.level();
        InteractionHand usedItemHand = player.getUsedItemHand();
        ItemStack itemStack = player.getItemInHand(usedItemHand);
        Item item = itemStack.getItem();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        GunConfig gunConfig = gunItem.getGunConfig();
        int maximumAmmunition = gunConfig.maximumAmmunition();
        if (gunConfig == GunData.OLD_PAINLESS) {
            return;
        }
        int currentAmmunition = (Integer)itemStack.getOrDefault(HumanDataComponents.AMMUNITION.get(), (Object)0);
        if (currentAmmunition >= maximumAmmunition) {
            return;
        }
        Supplier<ItemLike> ammunitionItemSupplier = gunConfig.ammunitionItemSupplier();
        if (ammunitionItemSupplier == null) {
            return;
        }
        ItemLike ammunitionItem = ammunitionItemSupplier.get();
        int reloadAmount = gunConfig.reloadAmount();
        int neededAmmunition = (int)Math.ceil((float)(maximumAmmunition - currentAmmunition) / (float)reloadAmount);
        boolean isPlayerImmortal = AVPPredicates.IS_IMMORTAL.test((LivingEntity)player);
        ItemConsumptionResult.Full full = result = isPlayerImmortal ? ItemConsumptionResult.Full.INSTANCE : GunReloading.consumeItemAmountFromInventory(player, ammunitionItem, neededAmmunition, true);
        Objects.requireNonNull(full);
        ItemConsumptionResult.Full full2 = full;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemConsumptionResult.Full.class, ItemConsumptionResult.None.class, ItemConsumptionResult.Partial.class}, (Object)full2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ItemConsumptionResult.Full full3 = full2;
                int n2 = neededAmmunition;
                break;
            }
            case 1: {
                ItemConsumptionResult.None none = (ItemConsumptionResult.None)((Object)full2);
                int n2 = 0;
                break;
            }
            case 2: {
                ItemConsumptionResult.Partial partial = (ItemConsumptionResult.Partial)((Object)full2);
                int n2 = ammunitionToRestore = neededAmmunition - partial.remainingAmount;
            }
        }
        if (ammunitionToRestore == 0) {
            return;
        }
        GunItem.reload.sendForItem((Entity)player, itemStack);
        FireModeConfig fireModeConfig = gunConfig.getDefaultFireMode();
        Supplier<SoundEvent> reloadStartSoundEvent = fireModeConfig.reloadStartSoundEvent();
        if (reloadStartSoundEvent != null) {
            level.playSound(null, player.blockPosition(), reloadStartSoundEvent.get(), SoundSource.PLAYERS);
        }
        itemStack.set(HumanDataComponents.AMMUNITION.get(), (Object)Math.min(currentAmmunition + ammunitionToRestore * reloadAmount, maximumAmmunition));
        if (!isPlayerImmortal) {
            double reloadTimeModifier = (double)EnchantmentUtil.getLevel(level, itemStack, (ResourceKey<Enchantment>)Enchantments.QUICK_CHARGE) * 0.2;
            int reloadTimeInTicks = (int)((double)gunConfig.reloadTimeInTicks() * (1.0 - reloadTimeModifier));
            player.getCooldowns().addCooldown(itemStack.getItem(), reloadTimeInTicks);
            ServerScheduler.schedule(() -> {
                InteractionHand interactionHand;
                ItemStack itemInHand;
                Supplier<SoundEvent> reloadFinishSoundEvent = fireModeConfig.reloadFinishSoundEvent();
                if (reloadFinishSoundEvent != null && Objects.equals(itemStack, itemInHand = player.getItemInHand(interactionHand = player.getUsedItemHand()))) {
                    level.playSound(null, player.blockPosition(), reloadFinishSoundEvent.get(), SoundSource.PLAYERS);
                }
            }, Duration.ofMillis((long)reloadTimeInTicks * 50L));
        }
    }

    public static ItemConsumptionResult consumeItemAmountFromInventory(Player player, ItemLike ammunitionItem, int amountToConsume, boolean consume) {
        ItemConsumptionResult result = GunReloading.consumeItemAmountFromInventoryNoSync(player, ammunitionItem, amountToConsume, consume);
        if (result == ItemConsumptionResult.None.INSTANCE) {
            return result;
        }
        player.getInventory().setChanged();
        player.inventoryMenu.broadcastChanges();
        return result;
    }

    private static ItemConsumptionResult consumeItemAmountFromInventoryNoSync(Player player, ItemLike ammunitionItem, int amountToConsume, boolean consume) {
        Inventory playerInventory = player.getInventory();
        int remainingAmountToConsume = amountToConsume;
        block5: for (ItemStack playerItemStack : playerInventory.items) {
            ItemConsumptionResult itemConsumptionResult;
            if (!playerItemStack.is((Item)AVPBlockItems.AMMO_CHEST.get())) continue;
            ItemConsumptionResult result = GunReloading.consumeFromAmmoChestItem(playerItemStack, remainingAmountToConsume, ammunitionItem, consume);
            Objects.requireNonNull(result);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemConsumptionResult.Full.class, ItemConsumptionResult.Partial.class, ItemConsumptionResult.None.class}, (Object)itemConsumptionResult, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    ItemConsumptionResult.Full full = (ItemConsumptionResult.Full)itemConsumptionResult;
                    return full;
                }
                case 1: {
                    ItemConsumptionResult.Partial partial = (ItemConsumptionResult.Partial)itemConsumptionResult;
                    remainingAmountToConsume = partial.remainingAmount;
                    continue block5;
                }
                case 2: 
            }
            ItemConsumptionResult.None none = (ItemConsumptionResult.None)itemConsumptionResult;
        }
        for (ItemStack playerItemStack : playerInventory.items) {
            if (!playerItemStack.is(ammunitionItem.asItem())) continue;
            int consumeCount = Math.min(playerItemStack.getCount(), remainingAmountToConsume);
            if (consume) {
                playerItemStack.shrink(consumeCount);
            }
            if ((remainingAmountToConsume -= consumeCount) != 0) continue;
            return ItemConsumptionResult.Full.INSTANCE;
        }
        if (remainingAmountToConsume == amountToConsume) {
            return ItemConsumptionResult.None.INSTANCE;
        }
        return new ItemConsumptionResult.Partial(remainingAmountToConsume);
    }

    private static ItemConsumptionResult consumeFromAmmoChestItem(ItemStack ammoChestStack, int amountToConsume, ItemLike ammunitionItem, boolean consume) {
        ItemContainerContents container = (ItemContainerContents)ammoChestStack.get(DataComponents.CONTAINER);
        if (container == null || amountToConsume <= 0) {
            return ItemConsumptionResult.None.INSTANCE;
        }
        int remainingAmountToConsume = amountToConsume;
        for (ItemStack itemStack : container.nonEmptyItems()) {
            if (!itemStack.is(ammunitionItem.asItem())) continue;
            int consumeCount = Math.min(itemStack.getCount(), remainingAmountToConsume);
            if (consume) {
                itemStack.shrink(consumeCount);
            }
            if ((remainingAmountToConsume -= consumeCount) != 0) continue;
            return ItemConsumptionResult.Full.INSTANCE;
        }
        return new ItemConsumptionResult.Partial(remainingAmountToConsume);
    }

    public static sealed interface ItemConsumptionResult {

        public record Partial(int remainingAmount) implements ItemConsumptionResult
        {
        }

        public static enum Full implements ItemConsumptionResult
        {
            INSTANCE;

        }

        public static enum None implements ItemConsumptionResult
        {
            INSTANCE;

        }
    }
}

