/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item.gun.attack.hitscan;

import com.avp.common.network.packet.C2SGunHitResultsPayload;
import com.avp.common.util.AVPPredicates;
import com.avp.service.Services;
import com.human.common.gameplay.item.gun.attack.GunAttackAction;
import com.human.common.gameplay.item.gun.attack.GunAttackConfig;
import com.human.common.gameplay.item.gun.attack.GunHitResult;
import com.human.common.gameplay.item.gun.attack.hitscan.GunHitScanAttackHandler;
import com.human.common.gameplay.item.gun.pipeline.GunShootResult;
import com.lib.common.gameplay.util.EnchantmentUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class HitScanGunAttackAction
implements GunAttackAction {
    public static final HitScanGunAttackAction INSTANCE = new HitScanGunAttackAction();

    private HitScanGunAttackAction() {
    }

    @Override
    public GunShootResult shoot(GunAttackConfig gunAttackConfig) {
        LivingEntity shooter = gunAttackConfig.shooter();
        Level level = shooter.level();
        double stepSize = 0.25;
        double maxDistance = gunAttackConfig.fireModeConfig().range();
        Vec3 origin = shooter.getEyePosition();
        Vec3 direction = shooter.getLookAngle().normalize();
        HashSet<UUID> hitEntityUUIDs = new HashSet<UUID>();
        HashSet<BlockPos> hitBlockPositions = new HashSet<BlockPos>();
        ArrayList<GunHitResult> hitResults = new ArrayList<GunHitResult>();
        int totalPierces = 0;
        int piercingBudget = EnchantmentUtil.getLevel(level, gunAttackConfig.gunItemStack(), (ResourceKey<Enchantment>)Enchantments.PIERCING) + 1;
        Vec3 current = origin;
        double distanceTraveled = 0.0;
        while (distanceTraveled < maxDistance && totalPierces < piercingBudget) {
            BlockPos blockPos;
            BlockHitResult blockHit;
            Vec3 next = current.add(direction.scale(0.25));
            distanceTraveled += 0.25;
            EntityHitResult entityHit = ProjectileUtil.getEntityHitResult((Level)level, (Entity)shooter, (Vec3)current, (Vec3)next, (AABB)shooter.getBoundingBox().expandTowards(direction.scale(maxDistance)).inflate(1.0), entity -> !hitEntityUUIDs.contains(entity.getUUID()) && (entity.getType() == EntityType.END_CRYSTAL || AVPPredicates.isLiving(entity)));
            if (entityHit != null) {
                Entity entity2 = entityHit.getEntity();
                hitEntityUUIDs.add(entity2.getUUID());
                hitResults.add(new GunHitResult.Entity(entity2.getUUID()));
                ++totalPierces;
            }
            if ((blockHit = level.clip(new ClipContext(current, next, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)shooter))).getType() == HitResult.Type.BLOCK && !hitBlockPositions.contains(blockPos = blockHit.getBlockPos())) {
                hitBlockPositions.add(blockPos);
                hitResults.add(new GunHitResult.Block(blockPos, blockHit.getDirection()));
                ++totalPierces;
            }
            current = next;
        }
        C2SGunHitResultsPayload gunHitResultsPayload = new C2SGunHitResultsPayload(hitResults);
        if (!level.isClientSide && !(shooter instanceof Player)) {
            GunHitScanAttackHandler.handle(gunHitResultsPayload, shooter);
            return GunShootResult.SHOT;
        }
        if (level.isClientSide && shooter instanceof Player) {
            Player player = (Player)shooter;
            this.applyRecoilToPlayer(gunAttackConfig, player, level);
            Services.CLIENT_NETWORKING.sendToServer(gunHitResultsPayload);
            return GunShootResult.SHOT;
        }
        return GunShootResult.FAILURE;
    }

    private void applyRecoilToPlayer(GunAttackConfig gunAttackConfig, Player player, Level level) {
        float baseRecoilX = level.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float recoil = gunAttackConfig.fireModeConfig().recoil();
        player.turn((double)(baseRecoilX * 2.0f), (double)(-recoil * 2.0f));
    }
}

