/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.data;

import com.lib.common.gameplay.NBTSerializable;
import java.time.Duration;
import net.minecraft.nbt.CompoundTag;

public class Cooldown
implements NBTSerializable {
    private final long maxCooldownInTicks;
    private final String name;
    private long cooldownInTicks;

    public static Cooldown withCooldownTime(String name, Duration cooldownTime) {
        return Cooldown.withCooldownTimeInTicks(name, (long)((double)cooldownTime.toMillis() / 50.0));
    }

    public static Cooldown withCooldownTimeInTicks(String name, long maxCooldownInTicks) {
        return new Cooldown(name, maxCooldownInTicks);
    }

    private Cooldown(String name, long maxCooldownInTicks) {
        this.maxCooldownInTicks = maxCooldownInTicks;
        this.name = name;
    }

    public void tick() {
        this.cooldownInTicks = Math.max(this.cooldownInTicks - 1L, 0L);
    }

    public boolean isActive() {
        return this.cooldownInTicks > 0L;
    }

    public void reset() {
        this.cooldownInTicks = this.maxCooldownInTicks;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void load(CompoundTag compoundTag) {
        compoundTag.putLong(this.name, this.cooldownInTicks);
    }

    @Override
    public void save(CompoundTag compoundTag) {
        if (compoundTag.contains(this.name)) {
            this.cooldownInTicks = compoundTag.getLong(this.name);
        }
    }
}

