/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.data;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;

public sealed interface EntityTypePredicate {
    public static final Codec<EntityTypePredicate> CODEC = Codec.either((Codec)Codec.STRING, (Codec)Codec.list((Codec)Codec.STRING)).flatXmap(EntityTypePredicate::decodePredicate, EntityTypePredicate::encodePredicate);

    public boolean test(EntityType<?> var1);

    private static DataResult<EntityTypePredicate> decodePredicate(Either<String, java.util.List<String>> either) {
        try {
            if (either.left().isPresent()) {
                String str = (String)either.left().get();
                if (str.startsWith("#")) {
                    ResourceLocation tagId = ResourceLocation.parse((String)str.substring(1));
                    TagKey tagKey = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)tagId);
                    return DataResult.success((Object)new Tag(tagKey));
                }
                EntityType entityType = (EntityType)EntityType.byString((String)str).orElseThrow(() -> new IllegalArgumentException("Unknown EntityType: " + str));
                return DataResult.success((Object)new Single(entityType));
            }
            java.util.List list = (java.util.List)either.right().get();
            java.util.List<EntityType> types = list.stream().map(EntityType::byString).map(opt -> opt.orElse(null)).filter(Objects::nonNull).toList();
            return DataResult.success((Object)new List(types));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Invalid EntityTypePredicate: " + e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DataResult<Either<String, java.util.List<String>>> encodePredicate(EntityTypePredicate predicate) {
        java.util.List<String> encoded;
        if (predicate instanceof Single) {
            EntityType<?> entityType;
            Single single = (Single)predicate;
            EntityType<?> entityType2 = entityType = single.entityType();
            return DataResult.success((Object)Either.left((Object)EntityType.getKey(entityType2).toString()));
        }
        if (predicate instanceof Tag) {
            TagKey<EntityType<?>> tagKey;
            Tag tag = (Tag)predicate;
            TagKey<EntityType<?>> entityTypeTagKey = tagKey = tag.entityTypeTagKey();
            return DataResult.success((Object)Either.left((Object)("#" + String.valueOf(entityTypeTagKey.location()))));
        }
        if (!(predicate instanceof List)) return DataResult.error(() -> "Unknown EntityTypePredicate variant");
        List list2 = (List)predicate;
        try {
            java.util.List<EntityType<?>> list;
            java.util.List<EntityType<?>> entityTypes = list = list2.entityTypes();
            encoded = entityTypes.stream().map(EntityType::getKey).map(ResourceLocation::toString).toList();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return DataResult.success((Object)Either.right(encoded));
    }

    public record Tag(TagKey<EntityType<?>> entityTypeTagKey) implements EntityTypePredicate
    {
        @Override
        public boolean test(EntityType<?> type) {
            return type.is(this.entityTypeTagKey);
        }
    }

    public record Single(EntityType<?> entityType) implements EntityTypePredicate
    {
        @Override
        public boolean test(EntityType<?> type) {
            return this.entityType == type;
        }
    }

    public record List(java.util.List<? extends EntityType<?>> entityTypes) implements EntityTypePredicate
    {
        @Override
        public boolean test(EntityType<?> type) {
            return this.entityTypes.stream().anyMatch(type::equals);
        }
    }
}

