/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.entity.ai.sensor.combat;

import com.just.core.functional.option.None;
import com.just.core.functional.option.Option;
import com.just.core.functional.option.Some;
import com.lib.common.gameplay.entity.ai.GOAPConstants;
import com.lib.common.gameplay.entity.ai.util.CombatResponse;
import com.lib.common.gameplay.entity.ai.util.ItemType;
import com.lib.common.gameplay.goap.GOAPSensor;
import com.lib.common.gameplay.goap.state.GOAPMutableWorldState;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Creeper;

public class CombatResponseSensor<T extends LivingEntity>
implements GOAPSensor<T> {
    @Override
    public void sense(T context, GOAPMutableWorldState worldState) {
        Option nearestTargetOption;
        boolean hasRangedWeapon = worldState.getOrDefault(GOAPConstants.ITEM_TYPES_IN_INVENTORY, Set.of()).contains(ItemType.rangedWeapon()) || this.isRangedWeaponEquippedInMainHand(worldState);
        Option option = nearestTargetOption = (Option)worldState.getOrDefault(GOAPConstants.NEAREST_ATTACK_TARGET_ENTITY, Option.none());
        Objects.requireNonNull(option);
        Option option2 = option;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{None.class, Some.class}, (Object)option2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                None none = (None)option2;
                worldState.set(GOAPConstants.COMBAT_RESPONSE, CombatResponse.rest());
                break;
            }
            case 1: {
                boolean isTargetLethal;
                Creeper creeper;
                Mob mob;
                Some some = (Some)option2;
                LivingEntity target = (LivingEntity)some.unwrap();
                boolean willTargetOneShotMe = target instanceof Mob && (mob = (Mob)target).getTarget() == context && target.getAttributes().hasAttribute(Attributes.ATTACK_DAMAGE) && Objects.requireNonNull(target.getAttribute(Attributes.ATTACK_DAMAGE)).getValue() > (double)context.getHealth();
                boolean isCreeperAboutToExplode = target instanceof Creeper && ((creeper = (Creeper)target).isIgnited() || creeper.getSwellDir() > 0);
                boolean bl = isTargetLethal = willTargetOneShotMe || isCreeperAboutToExplode;
                if (isTargetLethal && context.distanceToSqr((Entity)target) < 16.0) {
                    worldState.set(GOAPConstants.COMBAT_RESPONSE, CombatResponse.flight());
                    return;
                }
                if (hasRangedWeapon) {
                    worldState.set(GOAPConstants.COMBAT_RESPONSE, new CombatResponse.Fight(CombatResponse.FightType.RANGED));
                    return;
                }
                worldState.set(GOAPConstants.COMBAT_RESPONSE, new CombatResponse.Fight(CombatResponse.FightType.MELEE));
            }
        }
    }

    private boolean isRangedWeaponEquippedInMainHand(GOAPMutableWorldState worldState) {
        return worldState.getOrDefault(GOAPConstants.MAIN_HAND_ITEM_TYPE, ItemType.none()) == ItemType.rangedWeapon();
    }
}

