/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.entity.ai.util;

import com.avp.common.registry.tag.AVPItemTags;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public sealed interface ItemType {
    public static ItemType getForItem(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return ItemType.none();
        }
        if (itemStack.getItem().components().has(DataComponents.FOOD)) {
            return ItemType.food();
        }
        if (itemStack.is(AVPItemTags.MELEE_WEAPONS)) {
            return MeleeWeapon.INSTANCE;
        }
        if (itemStack.is(AVPItemTags.RANGED_WEAPONS)) {
            return RangedWeapon.INSTANCE;
        }
        return new Other(itemStack.getItem());
    }

    public static ItemType food() {
        return Food.INSTANCE;
    }

    public static ItemType meleeWeapon() {
        return MeleeWeapon.INSTANCE;
    }

    public static ItemType none() {
        return None.INSTANCE;
    }

    public static ItemType rangedWeapon() {
        return RangedWeapon.INSTANCE;
    }

    public static enum MeleeWeapon implements ItemType
    {
        INSTANCE;

    }

    public static enum RangedWeapon implements ItemType
    {
        INSTANCE;

    }

    public record Other(Item item) implements ItemType
    {
    }

    public static enum Food implements ItemType
    {
        INSTANCE;

    }

    public static enum None implements ItemType
    {
        INSTANCE;

    }
}

