/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.entity.manager;

import com.alien.common.gameplay.entity.living.alien.xenomorph.queen.Queen;
import com.lib.common.gameplay.NBTSerializable;
import com.lib.common.network.DataAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class CrawlingManager
implements NBTSerializable {
    private static final String NBT_CRAWLING = "crawling";
    private final PathfinderMob entity;
    private final DataAccessor<Boolean> isCrawling;

    public CrawlingManager(PathfinderMob entity, DataAccessor<Boolean> isCrawling) {
        this.entity = entity;
        this.isCrawling = isCrawling;
    }

    public void tick() {
        if (this.entity.level().isClientSide) {
            return;
        }
        if (this.entity instanceof Queen) {
            return;
        }
        this.tryToCrawl();
    }

    public boolean isCrawling() {
        return this.isCrawling.get();
    }

    private void tryToCrawl() {
        BlockPos blockPosition = this.entity.blockPosition();
        Level level = this.entity.level();
        PathNavigation navigation = this.entity.getNavigation();
        if (level.isClientSide) {
            return;
        }
        Path path = navigation.getPath();
        boolean isTight = this.isTightSpace(blockPosition);
        if (path != null && path.getNextNodeIndex() < path.getNodeCount()) {
            Node previousNode = path.getPreviousNode();
            isTight = isTight || previousNode != null && this.isTightSpace(previousNode.asBlockPos());
            Node nextNode = path.getNextNode();
            isTight = isTight || this.isTightSpace(nextNode.asBlockPos());
        }
        this.isCrawling.set(isTight);
    }

    private boolean isTightSpace(BlockPos blockPos) {
        BlockPos above;
        Level level = this.entity.level();
        BlockState aboveState = level.getBlockState(above = blockPos.above());
        return !aboveState.isAir() && aboveState.entityCanStandOn((BlockGetter)this.entity.level(), blockPos, (Entity)this.entity);
    }

    @Override
    public void load(CompoundTag compoundTag) {
        if (compoundTag.contains(NBT_CRAWLING)) {
            this.isCrawling.set(compoundTag.getBoolean(NBT_CRAWLING));
        }
    }

    @Override
    public void save(CompoundTag compoundTag) {
        compoundTag.putBoolean(NBT_CRAWLING, this.isCrawling.get().booleanValue());
    }
}

