/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.entity.manager;

import com.lib.common.gameplay.NBTSerializable;
import com.lib.common.gameplay.entity.manager.GeneMap;
import com.lib.common.util.GeneSerializationUtil;
import net.minecraft.nbt.CompoundTag;

public class GeneContainer
implements NBTSerializable {
    private static final String NBT_GENE_MODIFIERS = "geneModifiers";
    private static final String NBT_DORMANT_GENE_MODIFIERS = "dormantGeneModifiers";
    private final GeneMap geneMap = new GeneMap();
    private final GeneMap dormantGeneMap = new GeneMap();

    public GeneMap getActiveGeneMap() {
        return this.geneMap;
    }

    public GeneMap getDormantGeneMap() {
        return this.dormantGeneMap;
    }

    public void transfer(GeneContainer other, boolean activateDormantGenes) {
        other.geneMap.putAll(this.geneMap.getBackingMap());
        if (activateDormantGenes) {
            this.dormantGeneMap.getBackingMap().forEach(other.getActiveGeneMap()::add);
        } else {
            other.dormantGeneMap.putAll(this.dormantGeneMap.getBackingMap());
        }
    }

    public void clear() {
        this.geneMap.clear();
        this.dormantGeneMap.clear();
    }

    @Override
    public void load(CompoundTag compoundTag) {
        this.geneMap.clear();
        this.dormantGeneMap.clear();
        GeneSerializationUtil.loadGeneModifiers(NBT_GENE_MODIFIERS, compoundTag, this.geneMap);
        GeneSerializationUtil.loadGeneModifiers(NBT_DORMANT_GENE_MODIFIERS, compoundTag, this.dormantGeneMap);
        this.geneMap.setDirty();
    }

    @Override
    public void save(CompoundTag compoundTag) {
        GeneSerializationUtil.saveGeneModifiers(NBT_GENE_MODIFIERS, compoundTag, this.geneMap);
        GeneSerializationUtil.saveGeneModifiers(NBT_DORMANT_GENE_MODIFIERS, compoundTag, this.dormantGeneMap);
    }
}

