/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.goap.condition.expression;

import com.just.core.functional.option.Option;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public sealed interface GOAPExpression<T> {
    public static <T> Contains<T> contains(T expected) {
        return new Contains<T>(expected);
    }

    public static <T> DoesNotEqual<T> doesNotEqual(T expected) {
        return new DoesNotEqual<T>(expected);
    }

    public static <T> Equals<T> equalTo(T expected) {
        return new Equals<T>(expected);
    }

    public static Equals<Boolean> isFalse() {
        return GOAPExpression.equalTo(false);
    }

    public static Equals<Boolean> isTrue() {
        return GOAPExpression.equalTo(true);
    }

    public static <T extends Comparable<T>> LessThan<T> lessThan(T expected) {
        return new LessThan<T>(expected);
    }

    public static <T extends Comparable<T>> GreaterThan<T> greaterThan(T expected) {
        return new GreaterThan<T>(expected);
    }

    public static <T extends Option<?>> IsSome<T> isSome() {
        return new IsSome();
    }

    public static <T extends Option<?>> IsNone<T> isNone() {
        return new IsNone();
    }

    public static <T> GOAPExpression<T> where(Predicate<? super T> predicate, String description) {
        return new Where<T>(predicate, description);
    }

    public boolean evaluate(@NotNull T var1);

    public static final class Contains<T>
    implements GOAPExpression<Collection<T>> {
        private final T expected;

        private Contains(T expected) {
            this.expected = expected;
        }

        @Override
        public boolean evaluate(@NotNull Collection<T> actual) {
            return actual.contains(this.expected);
        }

        public String toString() {
            return "contains " + String.valueOf(this.expected);
        }
    }

    public static final class DoesNotEqual<T>
    implements GOAPExpression<T> {
        private final T expected;

        private DoesNotEqual(T expected) {
            this.expected = expected;
        }

        @Override
        public boolean evaluate(@NotNull T actual) {
            return !Objects.equals(this.expected, actual);
        }

        public String toString() {
            return "does not equal " + String.valueOf(this.expected);
        }
    }

    public static final class Equals<T>
    implements GOAPExpression<T> {
        private final T expected;

        private Equals(T expected) {
            this.expected = expected;
        }

        @Override
        public boolean evaluate(@NotNull T actual) {
            return Objects.equals(this.expected, actual);
        }

        public String toString() {
            return "equals " + String.valueOf(this.expected);
        }
    }

    public static final class LessThan<T extends Comparable<T>>
    implements GOAPExpression<T> {
        private final T threshold;

        private LessThan(T threshold) {
            this.threshold = threshold;
        }

        @Override
        public boolean evaluate(@NotNull T actual) {
            return actual.compareTo(this.threshold) < 0;
        }

        public String toString() {
            return "less than " + String.valueOf(this.threshold);
        }
    }

    public static final class GreaterThan<T extends Comparable<T>>
    implements GOAPExpression<T> {
        private final T threshold;

        private GreaterThan(T threshold) {
            this.threshold = threshold;
        }

        @Override
        public boolean evaluate(@NotNull T actual) {
            return actual.compareTo(this.threshold) > 0;
        }

        public String toString() {
            return "greater than " + String.valueOf(this.threshold);
        }
    }

    public static final class IsSome<T extends Option<?>>
    implements GOAPExpression<T> {
        private IsSome() {
        }

        @Override
        public boolean evaluate(@NotNull T actual) {
            return actual.isSome();
        }

        public String toString() {
            return "is some";
        }
    }

    public static final class IsNone<T extends Option<?>>
    implements GOAPExpression<T> {
        private IsNone() {
        }

        @Override
        public boolean evaluate(@NotNull T actual) {
            return actual.isNone();
        }

        public String toString() {
            return "is none";
        }
    }

    public static final class Where<T>
    implements GOAPExpression<T> {
        private final Predicate<? super T> predicate;
        private final String description;

        private Where(Predicate<? super T> predicate, String description) {
            this.predicate = predicate;
            this.description = description;
        }

        @Override
        public boolean evaluate(@NotNull T actual) {
            return this.predicate.test(actual);
        }

        public String toString() {
            return "where " + this.description;
        }
    }
}

