/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.util.spatial.sphere.layer;

import com.lib.common.gameplay.util.spatial.Vec3Like;
import com.lib.common.gameplay.util.spatial.sphere.Sphere;
import com.lib.common.gameplay.util.spatial.sphere.layer.SphereLayer;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public interface LayeredSphere
extends Sphere {
    public List<SphereLayer> getAllLayers();

    default public boolean isWithinLayerOrBelow(SphereLayer layer, Vec3Like pos) {
        double outerSqr;
        double distSqr = pos.distanceSquaredTo(this.getCenter());
        return distSqr <= (outerSqr = Math.pow(this.getRadius() * layer.getMaxNormalizedRadius(), 2.0));
    }

    default public boolean isBetweenLayers(SphereLayer inner, SphereLayer outer, Vec3Like pos) {
        double distSqr = pos.distanceSquaredTo(this.getCenter());
        double minSqr = Math.pow(this.getRadius() * inner.getMinNormalizedRadius(), 2.0);
        double maxSqr = Math.pow(this.getRadius() * outer.getMaxNormalizedRadius(), 2.0);
        return distSqr >= minSqr && distSqr <= maxSqr;
    }

    @Nullable
    default public SphereLayer getLayerOrNull(Vec3Like pos) {
        for (SphereLayer layer : this.getAllLayers()) {
            if (!layer.contains(this, pos)) continue;
            return layer;
        }
        return null;
    }
}

