/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.network;

import com.just.codec.stream.StreamCodec;
import com.just.core.functional.option.Option;
import com.lib.common.network.PersistenceMetadata;
import com.mojang.serialization.Codec;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;

public record DataKey<T>(ResourceLocation id, T initialValue, Option<PersistenceMetadata<T>> persistenceMetadata, Option<StreamCodec<T>> streamCodec) {
    @Override
    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DataKey dataKey = (DataKey)object;
        return Objects.equals(this.id, dataKey.id);
    }

    public static class Builder<U> {
        private final ResourceLocation id;
        private Option<PersistenceMetadata<U>> persistDataOption;
        private Option<StreamCodec<U>> streamCodecOption;

        public Builder(ResourceLocation id) {
            this.id = id;
            this.persistDataOption = Option.none();
            this.streamCodecOption = Option.none();
        }

        public Builder<U> networkSynchronized(StreamCodec<U> streamCodec) {
            this.streamCodecOption = Option.some(streamCodec);
            return this;
        }

        public Builder<U> persistent(String key, Codec<U> codec) {
            this.persistDataOption = Option.some(new PersistenceMetadata<U>(key, codec));
            return this;
        }

        public DataKey<U> build(U initialValue) {
            return new DataKey<U>(this.id, initialValue, this.persistDataOption, this.streamCodecOption);
        }
    }
}

