/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.util;

import com.lib.common.gameplay.entity.manager.GeneContainer;
import com.lib.common.gameplay.gene.Genes;
import com.lib.common.model.GeneCarrier;
import com.lib.common.registry.GeneBonusDataRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class EmbryoUtil {
    public static List<Entity> birthEmbryos(LivingEntity parentEntity, GeneContainer parentGeneContainer, Function<LivingEntity, @Nullable Entity> embryoFactory, int baseBirthCount) {
        Entity embryo;
        ArrayList<Entity> embryoList = new ArrayList<Entity>();
        double birthBonus = (double)baseBirthCount + parentGeneContainer.getActiveGeneMap().getValue(Genes.BONUS_EMBRYO_COUNT);
        int baseOffspring = (int)birthBonus;
        double fractionalChance = birthBonus - (double)baseOffspring;
        for (int i = 0; i < baseOffspring; ++i) {
            Entity embryo2 = embryoFactory.apply(parentEntity);
            if (embryo2 == null) continue;
            embryoList.add(embryo2);
        }
        if (parentEntity.getRandom().nextDouble() < fractionalChance && (embryo = embryoFactory.apply(parentEntity)) != null) {
            embryoList.add(embryo);
        }
        return embryoList;
    }

    public static void applyGenesToEmbryo(EntityType<?> parentType, GeneContainer parentGeneContainer, GeneCarrier offspring, boolean addBonusGenes) {
        GeneContainer offspringGeneContainer = offspring.getOrCreateGeneManager().getGeneContainer();
        parentGeneContainer.transfer(offspringGeneContainer, true);
        if (addBonusGenes) {
            GeneBonusDataRegistry.getOrDefault(parentType).forEach(offspringGeneContainer.getActiveGeneMap()::add);
        }
    }
}

